package com.jhscale.meter.entity;

import com.jhscale.common.annotation.FieldName;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.em.Font;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.entity.para.CuttingPosition;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.protocol.print.entity.para.StringPara;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.*;

/**
 * @author lie_w
 * @title: DeviceText
 * @projectName meter-jar
 * @description: 设备报表
 * @date 2022/8/2515:19
 */
public abstract class DeviceReport extends JSONModel {

    // 店铺名称
    private String storeName;

    // 设备名称
    private String deviceName;

    // top后缀
    private String suffix;

    // 日期
    private String date;

    // 金额小数点
    private Integer money;

    // 重量小数点
    private Integer weight;

    public DeviceReport() {
    }

    public DeviceReport(String suffix) {
        this.suffix = suffix;
    }

    /**
     * @param money
     * @param weight
     * @description: 内容段
     */
    public abstract List<Para> innerPara(Integer money, Integer weight) throws MeterException;

    /**
     * @description: 文件头
     **/
    public List<Para> topPara() throws MeterException {
        return Arrays.asList(new StringPara()
                .set_Font(Font.FONT1)
                .set_Grid(Grid.Defaul_Grid)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(0)
                .set_Content(String.format("%s%s%s", this.getStoreName(), this.getDeviceName(), this.getSuffix())), new PrintPara());
    }

    /**
     * @description: 文件时间
     **/
    public List<Para> datePara() throws MeterException {
        return Arrays.asList(new StringPara()
                .set_Font(Font.FONT1)
                .set_Grid(Grid.Middle_Right_Grid)
                .setStartX(0)
                .setStartY(8)
                .setOffsetX(384)
                .setOffsetY(0)
                .set_Content(String.format("%s：%s", PrintGeneralFactory.getInstance().dict("日期"),
                        this.getDate())), new PrintPara());
    }

    /**
     * @description: 分隔符
     **/
    public List<Para> splitPara() throws MeterException {
        return Arrays.asList(new StringPara()
                .set_Font(Font.FONT1)
                .set_Grid(Grid.Middle_Left_Grid)
                .setStartX(0)
                .setStartY(8)
                .setOffsetX(0)
                .setOffsetY(0)
                .set_Content("------------------------------------"), new PrintPara());
    }

    /**
     * @description: 文本
     **/
    public List<Para> titlePara(String title) throws MeterException {
        return Arrays.asList(new StringPara()
                .set_Font(Font.FONT1)
                .set_Grid(Grid.Middle_Left_Grid)
                .setStartX(0)
                .setStartY(8)
                .setOffsetX(0)
                .setOffsetY(0)
                .set_Content(title), new PrintPara());
    }

    /**
     * @description: 文本
     **/
    public Para textPara(String text) throws MeterException {
        return new StringPara()
                .set_Font(Font.FONT1)
                .set_Grid(Grid.Middle_Left_Grid)
                .setStartX(25)
                .setStartY(8)
                .setOffsetX(0)
                .setOffsetY(0)
                .set_Content(text);
    }

    /**
     * @description: 走纸到切割位
     **/
    public List<Para> cuttingPara() throws MeterException {
        return Arrays.asList(new StringPara()
                .set_Font(Font.FONT1)
                .set_Grid(Grid.Defaul_Grid)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(0)
                .set_Content(PrintGeneralFactory.getInstance().dict("完")), new PrintPara(), new CuttingPosition());
    }

    /**
     * @param money
     * @description: 字段打印段
     */
    protected List<Para> fieldPara(Integer money) throws MeterException {
        List<Para> paras = new ArrayList<>();
        Field[] fields = this.getClass().getDeclaredFields();
        if (fields.length > 0) {

            List<Field> fieldList = Arrays.asList(fields);
            Collections.sort(fieldList, new Comparator<Field>() {
                @Override
                public int compare(Field o1, Field o2) {
                    FieldName fo1 = o1.getAnnotation(FieldName.class);
                    FieldName fo2 = o2.getAnnotation(FieldName.class);
                    int fov1 = Objects.nonNull(fo1) ? fo1.sort() : 9999;
                    int fov2 = Objects.nonNull(fo2) ? fo2.sort() : 9999;
                    return fov1 > fov2 ? 1 : -1;
                }
            });

            for (Field field : fieldList) {
                try {
                    field.setAccessible(true);
                    CAItem item = (CAItem) field.get(this);
                    if (item != null && item.checkPara()) {
                        FieldName annotation = field.getAnnotation(FieldName.class);
                        if (annotation != null) {
                            if (annotation.title()) {
                                paras.addAll(this.titlePara(PrintGeneralFactory.getInstance().dict(annotation.name())));
                                paras.addAll(item.para(false, PrintGeneralFactory.getInstance().dict("累计额/笔数"), money));
                            } else {
                                paras.addAll(item.para(true,
                                        PrintGeneralFactory.getInstance().dict(annotation.name())
                                                + PrintGeneralFactory.getInstance().dict("累计额/笔数"), money));
                            }
                        }
                    }
                } catch (IllegalAccessException e) {
                }
            }
        }
        return paras;
    }

    public String getStoreName() {
        return StringUtils.isNotBlank(storeName) ? (storeName + "-") : "";
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getDeviceName() {
        return StringUtils.isNotBlank(deviceName) ? (deviceName + "-") : "";
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getSuffix() {
        return StringUtils.isNotBlank(suffix) ? suffix : "";
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getDate() {
        return StringUtils.isNotBlank(date) ? date : "";
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Integer getMoney() {
        return money;
    }

    public void setMoney(Integer money) {
        this.money = money;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }
}
