package com.jhscale.meter.entity;

import com.jhscale.common.annotation.FieldName;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.entity.item.ScaleItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.para.Para;

import java.util.List;

/**
 * @author lie_w
 * @title: LogReport
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/2511:21
 */
public class LOGReport extends DeviceReport {

    @FieldName(sort = 0, name = "销售", title = true)
    private ScaleItem scale;

    @FieldName(sort = 1, name = "退款", title = true)
    private CAItem refund;

    @FieldName(sort = 2, name = "未确认", title = true)
    private CAItem unconfirmed;

    @FieldName(sort = 3, name = "清除", title = true)
    private CAItem clear;

    @FieldName(sort = 4, name = "挂单笔数", title = true)
    private CAItem pendOrder;

    @FieldName(sort = 5, name = "自动模式", title = true)
    private CAItem automatic;

    @FieldName(sort = 10, name = "入库", title = true)
    private CAItem storage;

    @FieldName(sort = 11, name = "出库", title = true)
    private CAItem outLibrary;

    @FieldName(sort = 12, name = "盘库", title = true)
    private CAItem inventory;

    @FieldName(sort = 13, name = "订单", title = true)
    private CAItem order;

    @FieldName(sort = 14, name = "损耗", title = true)
    private CAItem loss;

    @FieldName(sort = 15, name = "折舍", title = true)
    private CAItem discount;

    @FieldName(sort = 100, name = "现金")
    private CAItem cash;

    @FieldName(sort = 101, name = "支付宝")
    private CAItem aliPay;

    @FieldName(sort = 102, name = "微信")
    private CAItem wechat;

    @FieldName(sort = 103, name = "卡付")
    private CAItem cardPay;

    @FieldName(sort = 104, name = "其他支付1")
    private CAItem otherPay1;

    @FieldName(sort = 105, name = "其他支付2")
    private CAItem otherPay2;

    @FieldName(sort = 106, name = "其他支付3")
    private CAItem otherPay3;

    @FieldName(sort = 107, name = "吉卡云支付")
    private CAItem jkyPay;

    @FieldName(sort = 108, name = "吉卡云赠送支付")
    private CAItem jkyGivePay;

    @FieldName(sort = 101, name = "吉卡云充值")
    private CAItem jkyRecharge;

    @FieldName(sort = 102, name = "吉卡云赠送充值")
    private CAItem jkyGiveRecharge;

    @FieldName(sort = 103, name = "特殊支付2")
    private CAItem specialPay2;

    @FieldName(sort = 104, name = "特殊支付3")
    private CAItem specialPay3;

    @FieldName(sort = 105, name = "特殊支付4")
    private CAItem specialPay4;

    @FieldName(sort = 106, name = "特殊支付5")
    private CAItem specialPay5;

    @FieldName(sort = 107, name = "特殊支付6")
    private CAItem specialPay6;

    @FieldName(sort = 108, name = "特殊支付7")
    private CAItem specialPay7;

    @FieldName(sort = 200, name = "汇总")
    private CAItem total;

    @FieldName(sort = 255, name = "错误笔数")
    private CAItem mistake;

    public LOGReport() {
        super(PrintGeneralFactory.getInstance().dict("销售报表"));
    }

    /**
     * @param money
     * @param weight
     * @description: 内容段
     */
    @Override
    public List<Para> innerPara(Integer money, Integer weight) throws MeterException {
        return this.fieldPara(money);
    }

    public ScaleItem getScale() {
        return scale;
    }

    public void setScale(ScaleItem scale) {
        this.scale = scale;
    }

    public CAItem getRefund() {
        return refund;
    }

    public void setRefund(CAItem refund) {
        this.refund = refund;
    }

    public CAItem getUnconfirmed() {
        return unconfirmed;
    }

    public void setUnconfirmed(CAItem unconfirmed) {
        this.unconfirmed = unconfirmed;
    }

    public CAItem getClear() {
        return clear;
    }

    public void setClear(CAItem clear) {
        this.clear = clear;
    }

    public CAItem getPendOrder() {
        return pendOrder;
    }

    public void setPendOrder(CAItem pendOrder) {
        this.pendOrder = pendOrder;
    }

    public CAItem getAutomatic() {
        return automatic;
    }

    public void setAutomatic(CAItem automatic) {
        this.automatic = automatic;
    }

    public CAItem getStorage() {
        return storage;
    }

    public void setStorage(CAItem storage) {
        this.storage = storage;
    }

    public CAItem getOutLibrary() {
        return outLibrary;
    }

    public void setOutLibrary(CAItem outLibrary) {
        this.outLibrary = outLibrary;
    }

    public CAItem getInventory() {
        return inventory;
    }

    public void setInventory(CAItem inventory) {
        this.inventory = inventory;
    }

    public CAItem getOrder() {
        return order;
    }

    public void setOrder(CAItem order) {
        this.order = order;
    }

    public CAItem getLoss() {
        return loss;
    }

    public void setLoss(CAItem loss) {
        this.loss = loss;
    }

    public CAItem getDiscount() {
        return discount;
    }

    public void setDiscount(CAItem discount) {
        this.discount = discount;
    }

    public CAItem getCash() {
        return cash;
    }

    public void setCash(CAItem cash) {
        this.cash = cash;
    }

    public CAItem getAliPay() {
        return aliPay;
    }

    public void setAliPay(CAItem aliPay) {
        this.aliPay = aliPay;
    }

    public CAItem getWechat() {
        return wechat;
    }

    public void setWechat(CAItem wechat) {
        this.wechat = wechat;
    }

    public CAItem getCardPay() {
        return cardPay;
    }

    public void setCardPay(CAItem cardPay) {
        this.cardPay = cardPay;
    }

    public CAItem getOtherPay1() {
        return otherPay1;
    }

    public void setOtherPay1(CAItem otherPay1) {
        this.otherPay1 = otherPay1;
    }

    public CAItem getOtherPay2() {
        return otherPay2;
    }

    public void setOtherPay2(CAItem otherPay2) {
        this.otherPay2 = otherPay2;
    }

    public CAItem getOtherPay3() {
        return otherPay3;
    }

    public void setOtherPay3(CAItem otherPay3) {
        this.otherPay3 = otherPay3;
    }

    public CAItem getJkyPay() {
        return jkyPay;
    }

    public void setJkyPay(CAItem jkyPay) {
        this.jkyPay = jkyPay;
    }

    public CAItem getJkyGivePay() {
        return jkyGivePay;
    }

    public void setJkyGivePay(CAItem jkyGivePay) {
        this.jkyGivePay = jkyGivePay;
    }

    public CAItem getJkyRecharge() {
        return jkyRecharge;
    }

    public void setJkyRecharge(CAItem jkyRecharge) {
        this.jkyRecharge = jkyRecharge;
    }

    public CAItem getJkyGiveRecharge() {
        return jkyGiveRecharge;
    }

    public void setJkyGiveRecharge(CAItem jkyGiveRecharge) {
        this.jkyGiveRecharge = jkyGiveRecharge;
    }

    public CAItem getSpecialPay2() {
        return specialPay2;
    }

    public void setSpecialPay2(CAItem specialPay2) {
        this.specialPay2 = specialPay2;
    }

    public CAItem getSpecialPay3() {
        return specialPay3;
    }

    public void setSpecialPay3(CAItem specialPay3) {
        this.specialPay3 = specialPay3;
    }

    public CAItem getSpecialPay4() {
        return specialPay4;
    }

    public void setSpecialPay4(CAItem specialPay4) {
        this.specialPay4 = specialPay4;
    }

    public CAItem getSpecialPay5() {
        return specialPay5;
    }

    public void setSpecialPay5(CAItem specialPay5) {
        this.specialPay5 = specialPay5;
    }

    public CAItem getSpecialPay6() {
        return specialPay6;
    }

    public void setSpecialPay6(CAItem specialPay6) {
        this.specialPay6 = specialPay6;
    }

    public CAItem getSpecialPay7() {
        return specialPay7;
    }

    public void setSpecialPay7(CAItem specialPay7) {
        this.specialPay7 = specialPay7;
    }

    public CAItem getTotal() {
        return total;
    }

    public void setTotal(CAItem total) {
        this.total = total;
    }

    public CAItem getMistake() {
        return mistake;
    }

    public void setMistake(CAItem mistake) {
        this.mistake = mistake;
    }
}
