package com.jhscale.meter.entity;

import com.jhscale.common.model.inter.JSONModel;

import java.util.LinkedList;
import java.util.Queue;

/**
 * @author lie_w
 * @title: MeterQueue
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/4/271:42
 */
public class MeterQueue<T> implements JSONModel {

    // 队列
    private Queue<T> queue;

    public MeterQueue() {
        this.queue = new LinkedList<>();
    }

    /**
     * @description: 向队列中添加元素
     **/
    public void enqueue(T command) {
        this.queue.add(command);
    }

    /**
     * @description: 从队列中移除元素并返回队首元素
     **/
    public T dequeue() {
        return this.queue.poll();
    }

    /**
     * @description: 获取队列大小
     **/
    public int size() {
        return this.queue.size();
    }

    /**
     * @description: 判断队列是否为空
     **/
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    /**
     * @description: 获取队首元素但不移除
     **/
    public T peek() {
        return this.queue.peek();
    }
}
