package com.jhscale.meter.entity;

import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.entity.item.PLUItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.constant.TMT;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.em.Font;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.protocol.print.entity.para.StringPara;
import com.jhscale.meter.utils.BigDecimalUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: PLUReport
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/2515:31
 */
public class PLUReport extends DeviceReport {

    // PLU报表明细
    private List<PLUItem> items;

    public PLUReport() {
        super(PrintGeneralFactory.getInstance().dict("PLU报表"));
    }

    public PLUReport(List<PLUItem> items) {
        this();
        this.items = items;
    }

    /**
     * @param money
     * @param weight
     * @description: 内容段
     */
    @Override
    public List<Para> innerPara(Integer money, Integer weight) throws MeterException {
        this.sort();
        List<Para> paras = new ArrayList<>();
        for (PLUItem item : items) {
            StringPara left = new StringPara()
                    .set_Font(Font.FONT1)
                    .set_Grid(Grid.Middle_Left_Grid)
                    .setStartX(0)
                    .setStartY(6)
                    .setOffsetX(0)
                    .setOffsetY(0)
                    .set_Content(String.format("%s:%s", Objects.nonNull(item.getPluNo()) ? item.getPluNo() : " ", item.getPluName()));
            StringPara right = new StringPara()
                    .set_Font(Font.FONT1)
                    .set_Grid(Grid.Middle_Right_Grid)
                    .setStartX(0)
                    .setStartY(6)
                    .setOffsetX(384)
                    .setOffsetY(0)
                    .set_Content(String.format("%s%s %s%s%s",
                            UnitEnum.计件.equals(item.unit()) ? BigDecimalUtils.bigDecimalToString(item.getAmount(), null, 0)
                                    : BigDecimalUtils.bigDecimalToString(item.getAmount(), weight, 3),
                            Objects.nonNull(item.unit()) ? item.unit().getName() : " su ",
                            GlobalPara.getInstance().getTMT(TMT.Money_Prefix, "¥"),
                            BigDecimalUtils.bigDecimalToString(item.getSingleMeter(), money),
                            GlobalPara.getInstance().getTMT(TMT.Money_Suffix, "元")));
            paras.add(left);
            paras.add(right);
            paras.add(new PrintPara());
        }
        return paras;
    }

    /**
     * @description: PLU明细排序
     **/
    public void sort() {
        if (this.items != null) {
            Collections.sort(this.items);
        }
    }

    public List<PLUItem> getItems() {
        return items;
    }

    public void setItems(List<PLUItem> items) {
        this.items = items;
    }
}
