package com.jhscale.meter.entity.item;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.annotation.FieldName;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.constant.TMT;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.em.Font;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.protocol.print.entity.para.StringPara;
import com.jhscale.meter.utils.BigDecimalUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: AmountMoney
 * @projectName meter-jar
 * @description: 数重量金额
 * @date 2022/8/2517:15
 */
public class CAItem extends JSONModel {

    @FieldName(sort = 1, name = "金额")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal amount;

    @FieldName(sort = 2, name = "笔数")
    private Integer count;

    public CAItem() {
    }

    public CAItem(BigDecimal amount, Integer count) {
        this.amount = amount;
        this.count = count;
    }

    /**
     * @description: 检查数据有效性
     **/
    public boolean checkPara() {
        return (Objects.nonNull(this.amount) && this.amount.compareTo(new BigDecimal(0)) == 1) || (Objects.nonNull(this.count) && this.count > 0);
    }

    /**
     * @description: 内容段
     **/
    public List<Para> para(boolean title, String text, Integer money) throws MeterException {
        return (Objects.nonNull(this.amount) && this.amount.compareTo(new BigDecimal(0)) == 1) || (Objects.nonNull(this.count) && this.count > 0) ?
                this.line(title, text, String.format("%s%s%s / %s",
                        GlobalPara.getInstance().getTMT(TMT.Money_Prefix, "¥"),
                        BigDecimalUtils.bigDecimalToString(this.getAmount(), money),
                        GlobalPara.getInstance().getTMT(TMT.Money_Suffix, "元"),
                        this.getCount())) : null;
    }

    /**
     * @description: 添加行数据
     **/
    public List<Para> line(boolean title, String prefix, String content) throws MeterException {
        return Arrays.asList(
                new StringPara()
                        .set_Font(Font.FONT1)
                        .set_Grid(Grid.Middle_Left_Grid)
                        .setStartX(title ? 0 : 25)
                        .setStartY(8)
                        .setOffsetX(0)
                        .setOffsetY(0)
                        .set_Content(prefix),
                new StringPara()
                        .set_Font(Font.FONT1)
                        .set_Grid(Grid.Middle_Right_Grid)
                        .setStartX(0)
                        .setStartY(8)
                        .setOffsetX(384)
                        .setOffsetY(0)
                        .set_Content(content),
                new PrintPara());
    }

    public BigDecimal getAmount() {
        return Objects.nonNull(this.amount) ? this.amount : new BigDecimal(0);
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getCount() {
        return Objects.nonNull(this.count) ? this.count : 0;
    }

    public void setCount(Integer count) {
        this.count = count;
    }
}
