package com.jhscale.meter.entity.item;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.annotation.FieldName;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.utils.BigDecimalUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: ScaleItem
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/2517:10
 */
public class ScaleItem extends CAItem {

    @FieldName(group = 0, sort = 3, jsl = "", name = "税额")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal cesse;

    @FieldName(group = 0, sort = 4, jsl = "", name = "税率")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal cost;

    @FieldName(group = 0, sort = 5, jsl = "", name = "服务费")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal serviceCharge;

    public ScaleItem() {
    }

    public ScaleItem(BigDecimal amount, Integer count, BigDecimal cesse, BigDecimal cost, BigDecimal serviceCharge) {
        super(amount, count);
        this.cesse = cesse;
        this.cost = cost;
        this.serviceCharge = serviceCharge;
    }

    @Override
    public boolean checkPara() {
        return super.checkPara()
                || ((Objects.nonNull(this.cesse) && this.cesse.compareTo(new BigDecimal(0)) == 1)
                || (Objects.nonNull(this.cost) && this.cost.compareTo(new BigDecimal(0)) == 1)
                || (Objects.nonNull(this.serviceCharge) && this.serviceCharge.compareTo(new BigDecimal(0)) == 1));
    }

    @Override
    public List<Para> para(boolean title, String text, Integer money) throws MeterException {
        List<Para> para = super.para(title, text, money);
        if (para != null) {
            if (Objects.nonNull(this.cesse) && this.cesse.compareTo(new BigDecimal(0)) == 1) {
                if (para == null) para = new ArrayList<>();
                para.addAll(this.line(title, "税额", BigDecimalUtils.bigDecimalToString(this.cesse, money)));
            }

            if (Objects.nonNull(this.cost) && this.cost.compareTo(new BigDecimal(0)) == 1) {
                if (para == null) para = new ArrayList<>();
                para.addAll(this.line(title, "税率", BigDecimalUtils.bigDecimalToString(this.cost, money)));
            }

            if (Objects.nonNull(this.serviceCharge) && this.serviceCharge.compareTo(new BigDecimal(0)) == 1) {
                if (para == null) para = new ArrayList<>();
                para.addAll(this.line(title, "服务费", BigDecimalUtils.bigDecimalToString(this.serviceCharge, money)));
            }
        }
        return para;
    }

    public BigDecimal getCesse() {
        return cesse;
    }

    public void setCesse(BigDecimal cesse) {
        this.cesse = cesse;
    }

    public BigDecimal getCost() {
        return cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getServiceCharge() {
        return serviceCharge;
    }

    public void setServiceCharge(BigDecimal serviceCharge) {
        this.serviceCharge = serviceCharge;
    }
}
