package com.jhscale.meter.entity.server;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.entity.CPReport;
import com.jhscale.meter.entity.item.CAItem;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lie_w
 * @title: LogReport
 * @projectName meter-jar
 * @description: 云支付报表
 * @date 2022/8/2511:21
 */
public class CPServerReport extends ServerReport {

    // 支付宝金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal alipay;

    // 支付宝实际金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal alipayActual;

    // 支付宝笔数
    private Integer alipayCount;

    // 微信金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal weixin;

    // 微信实际金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal weixinActual;

    // 微信笔数
    private Integer weixinCount;

    // 特殊支付
    private List<BillSpecial> billSpecial;

    /**
     * @description: 云支付报表打印
     **/
    public CPReport toReport() {
        CPReport report = new CPReport();
        report.setAliPay(new CAItem(this.alipay, this.alipayCount));
        report.setWechat(new CAItem(this.weixin, this.getAlipayCount()));
        if (billSpecial != null && !billSpecial.isEmpty()) {
            for (BillSpecial special : billSpecial) {
                if (StringUtils.isNotBlank(special.getPayWay())) {
                    switch (special.getPayWay()) {
                        case "70":
                            report.setUnion(new CAItem(special.getTotal(), special.getTotalCount()));
                            break;
                        case "71":
                            report.setJh(new CAItem(special.getTotal(), special.getTotalCount()));
                            break;
                        case "72":
                            report.setYz(new CAItem(special.getTotal(), special.getTotalCount()));
                            break;
                    }
                }
            }
        }
        return report;
    }

    public static class BillSpecial extends JSONModel {

        // 1-支付宝,2-微信,3-现金,4-吉卡云,70-云闪付,71-龙支付,72-邮政
        private String payWay;

        // 总金额
        @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
        private BigDecimal total;

        // 总金额实际到账
        @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
        private BigDecimal totalActual;

        // 总笔数
        private Integer totalCount;

        public String getPayWay() {
            return payWay;
        }

        public void setPayWay(String payWay) {
            this.payWay = payWay;
        }

        public BigDecimal getTotal() {
            return total;
        }

        public void setTotal(BigDecimal total) {
            this.total = total;
        }

        public BigDecimal getTotalActual() {
            return totalActual;
        }

        public void setTotalActual(BigDecimal totalActual) {
            this.totalActual = totalActual;
        }

        public Integer getTotalCount() {
            return totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }
    }

    public BigDecimal getAlipay() {
        return alipay;
    }

    public void setAlipay(BigDecimal alipay) {
        this.alipay = alipay;
    }

    public BigDecimal getAlipayActual() {
        return alipayActual;
    }

    public void setAlipayActual(BigDecimal alipayActual) {
        this.alipayActual = alipayActual;
    }

    public Integer getAlipayCount() {
        return alipayCount;
    }

    public void setAlipayCount(Integer alipayCount) {
        this.alipayCount = alipayCount;
    }

    public BigDecimal getWeixin() {
        return weixin;
    }

    public void setWeixin(BigDecimal weixin) {
        this.weixin = weixin;
    }

    public BigDecimal getWeixinActual() {
        return weixinActual;
    }

    public void setWeixinActual(BigDecimal weixinActual) {
        this.weixinActual = weixinActual;
    }

    public Integer getWeixinCount() {
        return weixinCount;
    }

    public void setWeixinCount(Integer weixinCount) {
        this.weixinCount = weixinCount;
    }

    public List<BillSpecial> getBillSpecial() {
        return billSpecial;
    }

    public void setBillSpecial(List<BillSpecial> billSpecial) {
        this.billSpecial = billSpecial;
    }
}
