package com.jhscale.meter.entity.server;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.entity.LOGReport;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.entity.item.ScaleItem;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: LOGServerReport
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/2517:38
 */
public class LOGServerReport extends ServerReport {

    // 总金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal totalAmount;

    // 总笔数
    private Integer totalCount;

    // 销售金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal saleAmount;

    // 销售笔数
    private Integer saleCount;

    // 退款金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal returnAmount;

    // 退款笔数
    private Integer returnCount;

    // 税额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal cesse;

    // 服务费
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal cost;

    // 现金金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal cash;

    // 现金笔数
    private Integer cashCount;

    // 卡付
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal cardPay;

    // 卡付笔数
    private Integer cardCount;

    // 支付宝金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal aliPay;

    // 支付宝笔数
    private Integer aliCount;

    // 微信金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal wechat;

    // 微信笔数
    private Integer wechatCount;

    // 其他支付1金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal otherPay1;

    // 其他支付1笔数
    private Integer otherCount1;

    // 其他支付2金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal otherPay2;

    // 其他支付2笔数
    private Integer otherCount2;

    // 其他支付3金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal otherPay3;

    // 其他支付3笔数
    private Integer otherCount3;

    // 吉卡云金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal jkyPay;

    // 吉卡云笔数
    private Integer jkyCount;

    // 吉卡云赠送金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal jkyGive;

    // 吉卡云赠送笔数
    private Integer jkyGiveCount;

    // 特殊支付2金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal specialPay2;

    // 特殊支付2笔数
    private Integer specialCount2;

    // 特殊支付3金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal specialPay3;

    // 特殊支付3笔数
    private Integer specialCount3;

    // 特殊支付4金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal specialPay4;

    // 特殊支付4笔数
    private Integer specialCount4;

    // 特殊支付5金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal specialPay5;

    // 特殊支付5笔数
    private Integer specialCount5;

    // 特殊支付6金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal specialPay6;

    // 特殊支付6笔数
    private Integer specialCount6;

    // 特殊支付7金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal specialPay7;

    // 特殊支付7笔数
    private Integer specialCount7;

    // 充值金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal recharge;

    // 充值笔数
    private Integer rechargeCount;

    // 充值赠送金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal rechargeGive;

    // 充值赠送笔数
    private Integer rechargeGiveCount;

    // 折舍金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal discountAmount;

    // 折舍笔数
    private Integer discountCount;

    // 服务费
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal serviceCharge;

    // 未确认金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal unconfirmed;

    // 未确认笔数
    private Integer unconfirmedCount;

    // 清除金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal clearAmount;

    // 清除笔数
    private Integer clear;

    // 错误笔数
    private Integer mistake;

    // 挂单笔数
    private Integer pendOrder;

    // 挂单金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal pendAmount;

    // 自动模式笔数
    private Integer automatic;

    // 自动模式金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal automaticAmount;

    // 入库笔数
    private Integer storage;

    // 入库金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal storageAmount;

    // 出库笔数
    private Integer outLibrary;

    // 出库金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal outAmount;

    // 盘库笔数
    private Integer inventory;

    // 盘库金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal inventoryAmount;

    // 订单笔数
    private Integer orderCount;

    // 订单金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal orderAmount;

    // 损耗笔数
    private Integer loss;

    // 损耗金额
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal lossAmount;

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public BigDecimal getSaleAmount() {
        return saleAmount;
    }

    public void setSaleAmount(BigDecimal saleAmount) {
        this.saleAmount = saleAmount;
    }

    public Integer getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public BigDecimal getReturnAmount() {
        return returnAmount;
    }

    public void setReturnAmount(BigDecimal returnAmount) {
        this.returnAmount = returnAmount;
    }

    public Integer getReturnCount() {
        return returnCount;
    }

    public void setReturnCount(Integer returnCount) {
        this.returnCount = returnCount;
    }

    public BigDecimal getCesse() {
        return cesse;
    }

    public void setCesse(BigDecimal cesse) {
        this.cesse = cesse;
    }

    public BigDecimal getCost() {
        return cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public Integer getCashCount() {
        return cashCount;
    }

    public void setCashCount(Integer cashCount) {
        this.cashCount = cashCount;
    }

    public BigDecimal getCardPay() {
        return cardPay;
    }

    public void setCardPay(BigDecimal cardPay) {
        this.cardPay = cardPay;
    }

    public Integer getCardCount() {
        return cardCount;
    }

    public void setCardCount(Integer cardCount) {
        this.cardCount = cardCount;
    }

    public BigDecimal getAliPay() {
        return aliPay;
    }

    public void setAliPay(BigDecimal aliPay) {
        this.aliPay = aliPay;
    }

    public Integer getAliCount() {
        return aliCount;
    }

    public void setAliCount(Integer aliCount) {
        this.aliCount = aliCount;
    }

    public BigDecimal getWechat() {
        return wechat;
    }

    public void setWechat(BigDecimal wechat) {
        this.wechat = wechat;
    }

    public Integer getWechatCount() {
        return wechatCount;
    }

    public void setWechatCount(Integer wechatCount) {
        this.wechatCount = wechatCount;
    }

    public BigDecimal getOtherPay1() {
        return otherPay1;
    }

    public void setOtherPay1(BigDecimal otherPay1) {
        this.otherPay1 = otherPay1;
    }

    public Integer getOtherCount1() {
        return otherCount1;
    }

    public void setOtherCount1(Integer otherCount1) {
        this.otherCount1 = otherCount1;
    }

    public BigDecimal getOtherPay2() {
        return otherPay2;
    }

    public void setOtherPay2(BigDecimal otherPay2) {
        this.otherPay2 = otherPay2;
    }

    public Integer getOtherCount2() {
        return otherCount2;
    }

    public void setOtherCount2(Integer otherCount2) {
        this.otherCount2 = otherCount2;
    }

    public BigDecimal getOtherPay3() {
        return otherPay3;
    }

    public void setOtherPay3(BigDecimal otherPay3) {
        this.otherPay3 = otherPay3;
    }

    public Integer getOtherCount3() {
        return otherCount3;
    }

    public void setOtherCount3(Integer otherCount3) {
        this.otherCount3 = otherCount3;
    }

    public BigDecimal getJkyPay() {
        return jkyPay;
    }

    public void setJkyPay(BigDecimal jkyPay) {
        this.jkyPay = jkyPay;
    }

    public Integer getJkyCount() {
        return jkyCount;
    }

    public void setJkyCount(Integer jkyCount) {
        this.jkyCount = jkyCount;
    }

    public BigDecimal getJkyGive() {
        return jkyGive;
    }

    public void setJkyGive(BigDecimal jkyGive) {
        this.jkyGive = jkyGive;
    }

    public Integer getJkyGiveCount() {
        return jkyGiveCount;
    }

    public void setJkyGiveCount(Integer jkyGiveCount) {
        this.jkyGiveCount = jkyGiveCount;
    }

    public BigDecimal getSpecialPay2() {
        return specialPay2;
    }

    public void setSpecialPay2(BigDecimal specialPay2) {
        this.specialPay2 = specialPay2;
    }

    public Integer getSpecialCount2() {
        return specialCount2;
    }

    public void setSpecialCount2(Integer specialCount2) {
        this.specialCount2 = specialCount2;
    }

    public BigDecimal getSpecialPay3() {
        return specialPay3;
    }

    public void setSpecialPay3(BigDecimal specialPay3) {
        this.specialPay3 = specialPay3;
    }

    public Integer getSpecialCount3() {
        return specialCount3;
    }

    public void setSpecialCount3(Integer specialCount3) {
        this.specialCount3 = specialCount3;
    }

    public BigDecimal getSpecialPay4() {
        return specialPay4;
    }

    public void setSpecialPay4(BigDecimal specialPay4) {
        this.specialPay4 = specialPay4;
    }

    public Integer getSpecialCount4() {
        return specialCount4;
    }

    public void setSpecialCount4(Integer specialCount4) {
        this.specialCount4 = specialCount4;
    }

    public BigDecimal getSpecialPay5() {
        return specialPay5;
    }

    public void setSpecialPay5(BigDecimal specialPay5) {
        this.specialPay5 = specialPay5;
    }

    public Integer getSpecialCount5() {
        return specialCount5;
    }

    public void setSpecialCount5(Integer specialCount5) {
        this.specialCount5 = specialCount5;
    }

    public BigDecimal getSpecialPay6() {
        return specialPay6;
    }

    public void setSpecialPay6(BigDecimal specialPay6) {
        this.specialPay6 = specialPay6;
    }

    public Integer getSpecialCount6() {
        return specialCount6;
    }

    public void setSpecialCount6(Integer specialCount6) {
        this.specialCount6 = specialCount6;
    }

    public BigDecimal getSpecialPay7() {
        return specialPay7;
    }

    public void setSpecialPay7(BigDecimal specialPay7) {
        this.specialPay7 = specialPay7;
    }

    public Integer getSpecialCount7() {
        return specialCount7;
    }

    public void setSpecialCount7(Integer specialCount7) {
        this.specialCount7 = specialCount7;
    }

    public BigDecimal getRecharge() {
        return recharge;
    }

    public void setRecharge(BigDecimal recharge) {
        this.recharge = recharge;
    }

    public Integer getRechargeCount() {
        return rechargeCount;
    }

    public void setRechargeCount(Integer rechargeCount) {
        this.rechargeCount = rechargeCount;
    }

    public BigDecimal getRechargeGive() {
        return rechargeGive;
    }

    public void setRechargeGive(BigDecimal rechargeGive) {
        this.rechargeGive = rechargeGive;
    }

    public Integer getRechargeGiveCount() {
        return rechargeGiveCount;
    }

    public void setRechargeGiveCount(Integer rechargeGiveCount) {
        this.rechargeGiveCount = rechargeGiveCount;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountCount() {
        return discountCount;
    }

    public void setDiscountCount(Integer discountCount) {
        this.discountCount = discountCount;
    }

    public BigDecimal getServiceCharge() {
        return serviceCharge;
    }

    public void setServiceCharge(BigDecimal serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public BigDecimal getUnconfirmed() {
        return unconfirmed;
    }

    public void setUnconfirmed(BigDecimal unconfirmed) {
        this.unconfirmed = unconfirmed;
    }

    public Integer getUnconfirmedCount() {
        return unconfirmedCount;
    }

    public void setUnconfirmedCount(Integer unconfirmedCount) {
        this.unconfirmedCount = unconfirmedCount;
    }

    public BigDecimal getClearAmount() {
        return clearAmount;
    }

    public void setClearAmount(BigDecimal clearAmount) {
        this.clearAmount = clearAmount;
    }

    public Integer getClear() {
        return clear;
    }

    public void setClear(Integer clear) {
        this.clear = clear;
    }

    public Integer getMistake() {
        return mistake;
    }

    public void setMistake(Integer mistake) {
        this.mistake = mistake;
    }

    public Integer getPendOrder() {
        return pendOrder;
    }

    public void setPendOrder(Integer pendOrder) {
        this.pendOrder = pendOrder;
    }

    public BigDecimal getPendAmount() {
        return pendAmount;
    }

    public void setPendAmount(BigDecimal pendAmount) {
        this.pendAmount = pendAmount;
    }

    public Integer getAutomatic() {
        return automatic;
    }

    public void setAutomatic(Integer automatic) {
        this.automatic = automatic;
    }

    public BigDecimal getAutomaticAmount() {
        return automaticAmount;
    }

    public void setAutomaticAmount(BigDecimal automaticAmount) {
        this.automaticAmount = automaticAmount;
    }

    public Integer getStorage() {
        return storage;
    }

    public void setStorage(Integer storage) {
        this.storage = storage;
    }

    public BigDecimal getStorageAmount() {
        return storageAmount;
    }

    public void setStorageAmount(BigDecimal storageAmount) {
        this.storageAmount = storageAmount;
    }

    public Integer getOutLibrary() {
        return outLibrary;
    }

    public void setOutLibrary(Integer outLibrary) {
        this.outLibrary = outLibrary;
    }

    public BigDecimal getOutAmount() {
        return outAmount;
    }

    public void setOutAmount(BigDecimal outAmount) {
        this.outAmount = outAmount;
    }

    public Integer getInventory() {
        return inventory;
    }

    public void setInventory(Integer inventory) {
        this.inventory = inventory;
    }

    public BigDecimal getInventoryAmount() {
        return inventoryAmount;
    }

    public void setInventoryAmount(BigDecimal inventoryAmount) {
        this.inventoryAmount = inventoryAmount;
    }

    public Integer getOrderCount() {
        return orderCount;
    }

    public void setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public Integer getLoss() {
        return loss;
    }

    public void setLoss(Integer loss) {
        this.loss = loss;
    }

    public BigDecimal getLossAmount() {
        return lossAmount;
    }

    public void setLossAmount(BigDecimal lossAmount) {
        this.lossAmount = lossAmount;
    }

    /**
     * @description: 转换成打印Report
     **/
    public LOGReport toReport() {
        LOGReport report = new LOGReport();
        report.setScale(new ScaleItem(this.saleAmount, this.saleCount, this.cesse, this.cost, this.serviceCharge));
        report.setRefund(new CAItem(this.returnAmount, this.returnCount));
        report.setUnconfirmed(new CAItem(this.unconfirmed, this.unconfirmedCount));
        report.setClear(new CAItem(this.clearAmount, this.clear));
        report.setPendOrder(new CAItem(this.pendAmount, this.pendOrder));
        report.setAutomatic(new CAItem(this.automaticAmount, this.automatic));
        report.setStorage(new CAItem(this.storageAmount, this.storage));
        report.setOutLibrary(new CAItem(this.outAmount, this.outLibrary));
        report.setInventory(new CAItem(this.inventoryAmount, this.inventory));
        report.setOrder(new CAItem(this.orderAmount, this.orderCount));
        report.setLoss(new CAItem(this.lossAmount, this.loss));
        report.setDiscount(new CAItem(this.discountAmount, this.discountCount));
        report.setCash(new CAItem(this.cash, this.cashCount));
        report.setAliPay(new CAItem(this.aliPay, this.aliCount));
        report.setWechat(new CAItem(this.wechat, this.wechatCount));
        report.setCardPay(new CAItem(this.cardPay, this.cardCount));
        report.setOtherPay1(new CAItem(this.otherPay1, this.otherCount1));
        report.setOtherPay2(new CAItem(this.otherPay2, this.otherCount3));
        report.setOtherPay3(new CAItem(this.otherPay3, this.otherCount3));
        report.setJkyPay(new CAItem(this.jkyPay, this.jkyCount));
        report.setJkyGivePay(new CAItem(this.jkyGive, this.jkyGiveCount));
        report.setJkyRecharge(new CAItem(this.recharge, this.rechargeCount));
        report.setJkyGiveRecharge(new CAItem(this.rechargeGive, this.rechargeGiveCount));
        report.setSpecialPay2(new CAItem(this.specialPay2, this.specialCount2));
        report.setSpecialPay3(new CAItem(this.specialPay3, this.specialCount3));
        report.setSpecialPay4(new CAItem(this.specialPay4, this.specialCount4));
        report.setSpecialPay5(new CAItem(this.specialPay5, this.specialCount5));
        report.setSpecialPay6(new CAItem(this.specialPay6, this.specialCount6));
        report.setSpecialPay7(new CAItem(this.specialPay7, this.specialCount7));
        report.setTotal(new CAItem(this.totalAmount, this.totalCount));
        report.setMistake(new CAItem(null, this.mistake));
        return report;
    }
}
