package com.jhscale.meter.entity.server;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.entity.server.order.Address;
import com.jhscale.meter.entity.server.order.DistributorNote;
import com.jhscale.meter.entity.server.order.MerchantNote;
import com.jhscale.meter.entity.server.order.OrderNoteDetail;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.line.*;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: ZXDOrder
 * @description: TODO
 * @date 2024/11/13 17:04
 */
public class ZXDOrder extends JSONModel {

    @ApiModelProperty(value = "打印位图", name = "bitmap")
    private Integer bitmap;

    @ApiModelProperty(value = "订单编号", name = "orderNo")
    private String orderNo;

    @ApiModelProperty(value = "订单标题", name = "title")
    private String title;

    @ApiModelProperty(value = "日结编号", name = "dailyNo")
    private String dailyNo;

    @ApiModelProperty(value = "送达取单时间", name = "arriveTime")
    private Date arriveTime;

    @ApiModelProperty(value = "配送方式 0-配送 1-自提", name = "delivery")
    private Integer delivery;

    @ApiModelProperty(value = "收货地址信息", name = "address")
    private String address;

    @ApiModelProperty(value = "消费者备注", name = "customerRemark")
    private String customerRemark;

    @ApiModelProperty(value = "生产者备注", name = "producerRemark")
    private String producerRemark;

    @ApiModelProperty(value = "明细数量", name = "count")
    private Integer count;

    @ApiModelProperty(value = "订单折扣后金额（只针对 订单原始金额 打折）", name = "originalGoodsMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal originalGoodsMoney;

    @ApiModelProperty(value = "订单最终价格", name = "finalGoodsMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal finalGoodsMoney;

    @ApiModelProperty(value = "打包原始金额（打包费 不参与折扣等优惠）", name = "originalPackMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal originalPackMoney;

    @ApiModelProperty(value = "打包最终金额", name = "finalPackMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal finalPackMoney;

    @ApiModelProperty(value = "服务费金额 （服务费 不参与折扣等优惠）", name = "originalServiceMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal originalServiceMoney;

    @ApiModelProperty(value = "服务最终金额", name = "finalServiceMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal finalServiceMoney;

    @ApiModelProperty(value = "订单金额", name = "finalMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal finalMoney;

    @ApiModelProperty(value = "支付类型(Binary 0000 0000) 128-会员支付 64-三方支付 192-会员+三方组合支付", name = "paymentType")
    private Integer paymentType;

    @ApiModelProperty(value = "三方支付渠道", name = "vpsChannel")
    private Integer vpsChannel;

    @ApiModelProperty(value = "支付备注", name = "paymentRemark")
    private String paymentRemark;

    @ApiModelProperty(value = "支付时间", name = "paymentTime")
    private Date paymentTime;

    @ApiModelProperty(value = "补差金额", name = "subsidyMoney")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal subsidyMoney;

    @ApiModelProperty(value = "订单内容信息", name = "orderDetail")
    private String orderDetail;

    /**
     * @description: 默认位图
     * @date: 2024-11-15 10:33:26
     **/
    public Integer bitmap() {
        return Objects.nonNull(this.bitmap) ? this.bitmap : 1;
    }

    public String customerRemark() {
        return StringUtils.isNotBlank(this.customerRemark) ? this.customerRemark : "";
    }

    public String producerRemark() {
        return StringUtils.isNotBlank(this.producerRemark) ? this.producerRemark : "";
    }

    /**
     * @description: 收货地址信息
     * @date: 2024-11-13 17:32:28
     **/
    public Address address() {
        return GJSONUtils.jsonToObject(this.address, Address.class);
    }

    /**
     * @description: 商户订单信息
     * @date: 2024-11-13 17:32:28
     **/
    public MerchantNote merchantNote() {
        return GJSONUtils.jsonToObject(this.orderDetail, MerchantNote.class);
    }

    /**
     * @description: 商户订单信息
     * @date: 2024-11-13 17:32:28
     **/
    public DistributorNote distributorNote() {
        return GJSONUtils.jsonToObject(this.orderDetail, DistributorNote.class);
    }

    public String finalGoodsMoney() {
        return GlobalPara.getInstance().Cal_Item(this.finalGoodsMoney).toString();
    }

    public String finalPackMoney() {
        return GlobalPara.getInstance().Cal_Item(this.finalPackMoney).toString();
    }

    public String finalMoney() {
        return GlobalPara.getInstance().Cal_Item(this.finalMoney).toString();
    }

    public String paymentType() {
        String paymentType = "";
        if (Objects.nonNull(this.paymentType)) {
            if (this.paymentType == 128) {
                paymentType += "会员支付";
            } else if (this.paymentType == 64) {
                paymentType += PayWay.orderPay(this.vpsChannel).getDescription();
            } else if (this.paymentType == 192) {
                paymentType += "会员支付" + PayWay.orderPay(this.vpsChannel).getDescription();
            } else {
                paymentType += this.paymentType + "支付";
            }
        }
        return paymentType;
    }

    /**
     * @description: 转服务商打印内容
     * @date: 2024-11-15 18:00:52
     **/
    public List<PrintLine> toDistributorPrintLine() {
        Address address = this.address();
        DistributorNote distributorNote = this.distributorNote();

        List<PrintLine> lines = new ArrayList<>();

        lines.add(new PrintLineBP(this.bitmap()));

        // 客户信息
        lines.add(new PrintLineN().setContent(String.format("预约时间：%s", DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(this.getArriveTime()))).setFont(1));
        lines.add(new PrintLineN().setContent(String.format("%s %s", address.getName(), address.phone())).setFont(5));
        String addressStr = address.address();
        if (StringUtils.isNotBlank(addressStr)) {
            lines.add(new PrintLineN().setContent(String.format("地址: %s", addressStr)).setFont(4));
        } else if (this.delivery == 1) {
            lines.add(new PrintLineN().setContent("地址: 客户自取").setFont(4));
        }

        // 编号以及备注
        lines.add(PrintLineN.separator(4));
        lines.add(new PrintLineLMR().setMid(this.getDailyNo()).setFont(7));
        if (StringUtils.isNotBlank(this.getCustomerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("顾客备注：%s", this.customerRemark())).setFont(4));
        }
        if (StringUtils.isNotBlank(this.getProducerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("商家备注：%s", this.getProducerRemark())).setFont(4));
        }
        lines.add(PrintLineN.separator(4));

        // 商品明细
        lines.add(new PrintLineLMR().setLeft("店铺").setFont(1));
        lines.add(new PrintLineLMR().setLeft("品名").setMid("数重量").setRight("小计").setFont(1));
        lines.add(PrintLineN.separator(1));

        for (int i = 0; i < distributorNote.getMerchantNotes().size(); i++) {
            MerchantNote merchantNote = distributorNote.getMerchantNotes().get(i);
            lines.add(new PrintLineN().setContent(String.format("%s[%s件]", merchantNote.getMallStoreOverall().getName(), merchantNote.getNoteDetails().size())).setFont(1));
            lines.add(PrintLineN.separator(1));
            for (OrderNoteDetail detail : merchantNote.getNoteDetails()) {
                lines.add(new PrintLineLMR()
                        .setLeft(detail.getGoodsName())
                        .setMid(detail.amount())
                        .setRight(detail.item())
                        .setFont(1));
            }
            if (i != distributorNote.getMerchantNotes().size() - 1) {
                lines.add(PrintLineN.separator(1));
            }
        }

        lines.add(PrintLineN.separator(1));
        lines.add(new PrintLineLMR().setRight(String.format("共计(%s)件", this.getCount())).setFont(4));

        // 空行
        lines.add(new PrintLineN());

        // 合计内容信息
        lines.add(new PrintLineLMR().setLeft("商品总额").setRight(this.finalGoodsMoney()).setFont(1));
        if (Objects.nonNull(this.finalPackMoney) && this.finalPackMoney.compareTo(BigDecimal.ZERO) > 0)
            lines.add(new PrintLineLMR().setLeft("打包总额").setRight(this.finalPackMoney()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("商品总计").setRight(this.finalMoney()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("支付方式").setRight(this.paymentType()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("支付时间").setRight(DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(this.getPaymentTime())).setFont(1));

        // 结尾信息
        lines.add(PrintLineN.separator(4));

        List<String> text = GlobalPara.getInstance().Mall_Text();
        if (!text.isEmpty()) {
            if (text.size() == 1) {
                lines.add(new PrintLineLMR().setMid(text.get(0)).setFont(1));
            } else {
                for (String t : text) {
                    lines.add(new PrintLineN().setContent(t).setFont(1));
                }
            }
        }

        lines.add(new PrintLineBC().setContent(this.orderNo));
        lines.add(new PrintLineLMR().setMid(this.orderNo));
        return lines;
    }


    /**
     * @description: 转商户打印内容
     * @date: 2024-11-15 14:54:11
     **/
    public List<PrintLine> toMerchantPrintLine() {
        Address address = this.address();
        MerchantNote merchantNote = this.merchantNote();

        List<PrintLine> lines = new ArrayList<>();

        lines.add(new PrintLineBP(this.bitmap()));

        // 客户信息
        lines.add(new PrintLineN().setContent(String.format("预约时间：%s", DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(this.getArriveTime()))).setFont(1));
        lines.add(new PrintLineN().setContent(String.format("%s %s", address.getName(), address.phone())).setFont(5));
        String addressStr = address.address();
        if (StringUtils.isNotBlank(addressStr)) {
            lines.add(new PrintLineN().setContent(String.format("地址: %s", addressStr)).setFont(4));
        } else if (this.delivery == 1) {
            lines.add(new PrintLineN().setContent("地址: 客户自取").setFont(4));
        }

        // 编号以及备注
        lines.add(PrintLineN.separator(4));
        lines.add(new PrintLineLMR().setMid(this.getDailyNo()).setFont(7));
        if (StringUtils.isNotBlank(this.getCustomerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("顾客备注：%s", this.customerRemark())).setFont(4));
        }
        if (StringUtils.isNotBlank(this.getProducerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("商家备注：%s", this.getProducerRemark())).setFont(4));
        }
        lines.add(PrintLineN.separator(4));

        // 商品明细
        lines.add(new PrintLineLMR().setLeft("品名").setMid("数重量").setRight("小计").setFont(1));
        lines.add(PrintLineN.separator(1));
        for (OrderNoteDetail detail : merchantNote.getNoteDetails()) {
            lines.add(new PrintLineLMR()
                    .setLeft(detail.getGoodsName())
                    .setMid(detail.amount())
                    .setRight(detail.item())
                    .setFont(1));
        }
        lines.add(PrintLineN.separator(1));
        lines.add(new PrintLineLMR().setRight(String.format("共计(%s)件", this.getCount())).setFont(4));

        // 空行
        lines.add(new PrintLineN());

        // 合计内容信息
        lines.add(new PrintLineLMR().setLeft("商品总额").setRight(this.finalGoodsMoney()).setFont(1));
        if (Objects.nonNull(this.finalPackMoney) && this.finalPackMoney.compareTo(BigDecimal.ZERO) > 0)
            lines.add(new PrintLineLMR().setLeft("打包总额").setRight(this.finalPackMoney()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("商品总计").setRight(this.finalMoney()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("支付方式").setRight(this.paymentType()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("支付时间").setRight(DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(this.getPaymentTime())).setFont(1));

        // 结尾信息
        lines.add(PrintLineN.separator(4));

        List<String> text = GlobalPara.getInstance().Mall_Text();
        if (!text.isEmpty()) {
            if (text.size() == 1) {
                lines.add(new PrintLineLMR().setMid(text.get(0)).setFont(1));
            } else {
                for (String t : text) {
                    lines.add(new PrintLineN().setContent(t).setFont(1));
                }
            }
        }

        lines.add(new PrintLineBC().setContent(this.orderNo));
        lines.add(new PrintLineLMR().setMid(this.orderNo));
        return lines;
    }

    public Integer getBitmap() {
        return bitmap;
    }

    public void setBitmap(Integer bitmap) {
        this.bitmap = bitmap;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDailyNo() {
        return dailyNo;
    }

    public void setDailyNo(String dailyNo) {
        this.dailyNo = dailyNo;
    }

    public Date getArriveTime() {
        return arriveTime;
    }

    public void setArriveTime(Date arriveTime) {
        this.arriveTime = arriveTime;
    }

    public Integer getDelivery() {
        return delivery;
    }

    public void setDelivery(Integer delivery) {
        this.delivery = delivery;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCustomerRemark() {
        return customerRemark;
    }

    public void setCustomerRemark(String customerRemark) {
        this.customerRemark = customerRemark;
    }

    public String getProducerRemark() {
        return producerRemark;
    }

    public void setProducerRemark(String producerRemark) {
        this.producerRemark = producerRemark;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BigDecimal getOriginalGoodsMoney() {
        return originalGoodsMoney;
    }

    public void setOriginalGoodsMoney(BigDecimal originalGoodsMoney) {
        this.originalGoodsMoney = originalGoodsMoney;
    }

    public BigDecimal getFinalGoodsMoney() {
        return finalGoodsMoney;
    }

    public void setFinalGoodsMoney(BigDecimal finalGoodsMoney) {
        this.finalGoodsMoney = finalGoodsMoney;
    }

    public BigDecimal getOriginalPackMoney() {
        return originalPackMoney;
    }

    public void setOriginalPackMoney(BigDecimal originalPackMoney) {
        this.originalPackMoney = originalPackMoney;
    }

    public BigDecimal getFinalPackMoney() {
        return finalPackMoney;
    }

    public void setFinalPackMoney(BigDecimal finalPackMoney) {
        this.finalPackMoney = finalPackMoney;
    }

    public BigDecimal getOriginalServiceMoney() {
        return originalServiceMoney;
    }

    public void setOriginalServiceMoney(BigDecimal originalServiceMoney) {
        this.originalServiceMoney = originalServiceMoney;
    }

    public BigDecimal getFinalServiceMoney() {
        return finalServiceMoney;
    }

    public void setFinalServiceMoney(BigDecimal finalServiceMoney) {
        this.finalServiceMoney = finalServiceMoney;
    }

    public BigDecimal getFinalMoney() {
        return finalMoney;
    }

    public void setFinalMoney(BigDecimal finalMoney) {
        this.finalMoney = finalMoney;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Integer getVpsChannel() {
        return vpsChannel;
    }

    public void setVpsChannel(Integer vpsChannel) {
        this.vpsChannel = vpsChannel;
    }

    public String getPaymentRemark() {
        return paymentRemark;
    }

    public void setPaymentRemark(String paymentRemark) {
        this.paymentRemark = paymentRemark;
    }

    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    public BigDecimal getSubsidyMoney() {
        return subsidyMoney;
    }

    public void setSubsidyMoney(BigDecimal subsidyMoney) {
        this.subsidyMoney = subsidyMoney;
    }

    public String getOrderDetail() {
        return orderDetail;
    }

    public void setOrderDetail(String orderDetail) {
        this.orderDetail = orderDetail;
    }
}
