package com.jhscale.meter.entity.server.order;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.PrivacyUtils;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: Address
 * @description: TODO
 * @date 2024/11/14 22:00
 */
public class Address implements GJSONModel {

    @ApiModelProperty(value = "收货人名称 (新增 必填)", name = "name")
    private String name;

    @ApiModelProperty(value = "收货人手机 (新增 必填)", name = "phone")
    private String phone;

    @ApiModelProperty(value = "地区名称 (新增 必填)", name = "areaName")
    private String areaName;

    @ApiModelProperty(value = "地址名称 (新增 必填)", name = "address")
    private String address;

    /**
     * @description: 收货地址信息
     * @date: 2024-11-15 10:39:05
     **/
    public String address() {
        return String.format("%s %s",
                StringUtils.isNotBlank(this.areaName) ? this.areaName : "",
                StringUtils.isNotBlank(this.address) ? this.address : "").trim();
    }

    /**
     * @description: 手机号隐私
     * @date: 2024-11-15 11:18:35
     **/
    public String phone() {
        return PrivacyUtils.vagueMobile(this.phone);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
}
