package com.jhscale.meter.entity.server.order;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.model.GlobalPara;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: OrderDetailNote
 * @description: TODO
 * @date 2024/11/14 22:06
 */
public class OrderNoteDetail implements GJSONModel {

    @ApiModelProperty(value = "序号", name = "serial")
    private int serial;

    @ApiModelProperty(value = "分类名称", name = "categoryName")
    private String categoryName;

    @ApiModelProperty(value = "商品名称", name = "goodsName")
    private String goodsName;

    @ApiModelProperty(value = "单位（商城显示单位）", name = "unit")
    private Integer unit;

    @ApiModelProperty(value = "自定义量词", name = "unitText")
    private String unitText;

    @ApiModelProperty(value = "商品规格标题", name = "specTitle")
    private String specTitle;

    @ApiModelProperty(value = "购买数重量", name = "goodsAmount")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal goodsAmount;

    @ApiModelProperty(value = "小计金额(小计 =  单价 * 购买数重量)", name = "goodsItem")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal goodsItem;

    @ApiModelProperty(value = "补差数重量", name = "subsidyAmount")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal subsidyAmount;

    @ApiModelProperty(value = "补差小计", name = "subsidyItem")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal subsidyItem;

    public BigDecimal goodsAmount() {
        return Objects.nonNull(this.goodsAmount) ? this.goodsAmount : BigDecimal.ZERO;
    }

    public BigDecimal goodsItem() {
        return Objects.nonNull(this.goodsItem) ? this.goodsItem : BigDecimal.ZERO;
    }

    public BigDecimal subsidyAmount() {
        return Objects.nonNull(this.subsidyAmount) ? this.subsidyAmount : BigDecimal.ZERO;
    }

    public BigDecimal subsidyItem() {
        return Objects.nonNull(this.subsidyItem) ? this.subsidyItem : BigDecimal.ZERO;
    }

    public String amount() {
        UnitEnum unit = UnitEnum.unit(this.unit);
        String str = "";
        // BigDecimal amount = this.goodsAmount().subtract(this.subsidyAmount());
        BigDecimal amount = this.goodsAmount();
        if (UnitType.计件.equals(unit.getType())) {
            str = amount.setScale(0, RoundingMode.HALF_UP).toString();
        } else {
            str = amount.setScale(GlobalPara.getInstance().getTMS(TMS.Dot_Weight), RoundingMode.HALF_UP).toString();
        }
        if (StringUtils.isNotBlank(str)) {
            if (StringUtils.isNotBlank(this.specTitle)) {
                str += " " + this.specTitle;
            } else {
                str += " " + GlobalPara.getInstance().EcsCal_Unit_LoadName(unit.val(), this.unitText);
            }
        }
        return str;
    }

    public String item() {
        // BigDecimal item = this.goodsItem().subtract(this.subsidyItem());
        BigDecimal item = this.goodsItem();
        return GlobalPara.getInstance().Cal_Item(item).toString();
    }

    public int getSerial() {
        return serial;
    }

    public void setSerial(int serial) {
        this.serial = serial;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getUnitText() {
        return unitText;
    }

    public void setUnitText(String unitText) {
        this.unitText = unitText;
    }

    public String getSpecTitle() {
        return specTitle;
    }

    public void setSpecTitle(String specTitle) {
        this.specTitle = specTitle;
    }

    public BigDecimal getGoodsAmount() {
        return goodsAmount;
    }

    public void setGoodsAmount(BigDecimal goodsAmount) {
        this.goodsAmount = goodsAmount;
    }

    public BigDecimal getGoodsItem() {
        return goodsItem;
    }

    public void setGoodsItem(BigDecimal goodsItem) {
        this.goodsItem = goodsItem;
    }

    public BigDecimal getSubsidyAmount() {
        return subsidyAmount;
    }

    public void setSubsidyAmount(BigDecimal subsidyAmount) {
        this.subsidyAmount = subsidyAmount;
    }

    public BigDecimal getSubsidyItem() {
        return subsidyItem;
    }

    public void setSubsidyItem(BigDecimal subsidyItem) {
        this.subsidyItem = subsidyItem;
    }
}
