package com.jhscale.meter.exp;

/**
 * @author lie_w
 * @title: MeterExpEnum
 * @projectName jh-meter
 * @description: TODO
 * @date 2021/6/413:24
 */
public enum MeterStateEnum {

    /**
     * @description: 00XXXX - 基本业务信息
     **/
    成功("000000", "成功"),
    获取流长度失败("000001", "获取流长度失败"),
    流写入错误("000002", "流写入错误"),
    流读取错误("000003", "流读取错误"),
    反射结果异常("000004", "反射结果异常"),
    反射结果失败("000005", "反射结果失败"),
    通讯器未初始化("000006", "通讯器未初始化"),
    端口未打开("000006", "端口未打开"),
    其他未知异常("000007", "其他未知异常"),
    AES加密失败("000008", "AES加密失败"),
    AES解密失败("000009", "AES解密失败"),
    加解密模块未初始化("00000A", "加解密模块未初始化"),
    加载集中收银失败("00000B", "加载集中收银失败"),
    集中收银内容段长度不合法("00000C", "集中收银内容段长度不合法"),
    API废弃("00000D", "API废弃"),
    多连接通讯读写异常("00000E", "多连接通讯读写异常"),
    地址未找到("00000F", "地址未找到"),
    空异常信息("000010", "空异常信息"),
    Exception异常信息("000011", "Exception异常信息"),
    数据组装解析器编号不能为空("000012", "数据组装解析器编号不能为空"),
    数据组装解析器未找到("000013", "数据组装解析器未找到"),
    通讯超时时间不合法("000014", "通讯超时时间不合法"),
    协议组装失败("000015", "协议组装失败"),
    发送内容不存在("000016", "发送内容不存在"),
    无效指令("000017", "无效指令"),
    单项唯一通讯异常("000018", "单项唯一通讯异常"),
    通讯响应超时("000019", "通讯响应超时"),
    子包拆解失败("00001A", "子包拆解失败"),

    /**
     * @description: 01XXXX - 串口错误信息
     **/
    串口打开失败("010001", "串口打开失败"),
    串口写入错误("010002", "串口写入错误"),
    串口读取错误("010003", "串口读取错误"),
    端口指向设备不是串口类型("010004", "端口指向设备不是串口类型"),
    没有该端口对应的串口设备("010005", "没有该端口对应的串口设备"),
    端口已被占用("010006", "端口已被占用"),
    设置串口参数失败("010007", "设置串口参数失败"),
    获取串口输出流失败("010008", "获取串口输出流失败"),
    获取串口输入流失败("010009", "获取串口输入流失败"),
    串口未打开("010000A", "串口未打开"),
    监听类对象过多("010000B", "监听类对象过多"),
    串口开启查找异常("01000C", "串口开启查找异常"),
    串口关闭查找异常("01000D", "串口关闭查找异常"),
    向串口发送数据失败("01000E", "向串口发送数据失败"),
    关闭串口对象的输出流出错("01000F", "关闭串口对象的输出流出错"),
    从串口读取数据时出错("010010", "从串口读取数据时出错"),
    关闭串口对象输入流出错("010011", "关闭串口对象输入流出错"),

    /**
     * @description: 02XXXX - 蓝牙错误信息
     **/
    未发现蓝牙驱动设备("020001", "未发现蓝牙驱动设备"),
    检查蓝牙信息失败("020002", "检查蓝牙信息失败"),
    检查蓝牙PROPERTY信息失败("020003", "检查蓝牙PROPERTY信息失败"),
    检查蓝牙LOCAL_DEVICE信息失败("020004", "检查蓝牙LOCAL_DEVICE信息失败"),
    检查蓝牙FEATURE信息失败("020005", "检查蓝牙FEATURE信息失败"),
    检查蓝牙MAC无效("020006", "检查蓝牙MAC无效"),
    蓝牙开启查找设备异常("020007", "蓝牙开启查找设备异常"),
    蓝牙关闭查找设备异常("020008", "蓝牙关闭查找设备异常"),
    蓝牙打开失败("020009", "蓝牙打开失败"),
    蓝牙未打开("020000A", "蓝牙未打开"),
    获取蓝牙输出流失败("01000B", "获取蓝牙输出流失败"),
    获取蓝牙输入流失败("01000C", "获取蓝牙输入流失败"),
    蓝牙写入错误("01000D", "蓝牙写入错误"),
    蓝牙读取错误("01000E", "蓝牙读取错误"),
    蓝牙关闭异常("01000F", "蓝牙关闭异常"),
    蓝牙开启查找异常("010010", "蓝牙开启查找异常"),
    蓝牙关闭查找异常("010011", "蓝牙关闭查找异常"),

    /**
     * @description: 03XXXX - USB错误信息
     **/
    USB开启查找异常("030001", "USB开启查找异常"),
    USB关闭查找异常("030002", "USB关闭查找异常"),
    USB打开失败("030003", "USB打开失败"),
    USB写入错误("030004", "USB写入错误"),
    USB读取错误("030005", "USB读取错误"),
    USB设别查找异常("030006", "USB设别查找异常"),
    USB连接失败("030007", "USB连接失败"),
    未找到USB接口("030008", "未找到USB接口"),
    USB未打开("030009", "USB未打开"),
    USB_OUT输出异常("03000A", "USB_IO输出异常"),
    USB_OUT关闭异常("03000B", "USB_OUT关闭异常"),
    USB_IN关闭异常("03000A", "USB_IN关闭异常"),
    USB关闭异常("03000C", "USB关闭异常"),

    /**
     *
     **/
    NFC不支持("040001", "NFC不支持"),

    /**
     * @description: 05XXXX - WIFI错误信息
     **/
    WIFI不支持("040001", "WIFI不支持"),

    /**
     * @description: 06XXXX - AD错误信息
     **/
    AD指令不存在("060001", "AD指令不存在"),
    AD响应指令无效("060002", "AD响应指令无效"),
    AD数据包格式错误("060003", "AD数据包格式错误"),
    AD数据包头无效("060004", "AD数据包头无效"),
    AD数据包尾无效("060005", "AD数据包尾无效"),
    AD数据包长度检查错误("060006", "AD数据包长度检查错误"),
    AD校验码无效("060007", "AD校验码无效"),

    AD_AD码解析失败("060008", "AD_AD码解析失败"),
    AD_开机状态读取解析失败("060009", "AD_开机状态读取解析失败"),
    AD_开机零点范围读取解析失败("06000A", "AD_开机零点范围读取解析失败"),
    AD_分度值读取解析失败("06000B", "AD_分度值读取解析失败"),
    AD_滤波强度读取解析失败("06000C", "AD_滤波强度读取解析失败"),
    AD_满量程读取解析失败("06000D", "AD_满量程读取解析失败"),
    AD_内码读取解析失败("06000E", "AD_内码读取解析失败"),
    AD_读取Mac解析失败("06000F", "AD_读取Mac解析失败"),
    AD_版本号读取解析失败("060010", "AD_版本号读取解析失败"),
    AD_重量发送速率读取解析失败("060011", "AD_重量发送速率读取解析失败"),
    AD_读取重量解析失败("060012", "AD_读取重量解析失败"),
    AD_零点跟踪范围读取解析失败("060013", "AD_零点跟踪范围读取解析失败"),
    AD_操作结果解析失败("060014", "AD_操作结果解析失败"),
    AD_读取温度补偿使能状态解析失败("060015", "AD_读取温度补偿使能状态解析失败"),
    AD_读取当前温度解析失败("060016", "AD_读取当前温度解析失败"),

    AD_数据格式错误("060017", "AD_数据格式错误"),
    AD_皮重无效("060018", "AD_皮重[0-16777215]无效"),
    AD_发送速率无效("060019", "AD_发送速率[1-30]无效"),
    AD_开机零点范围无效("06001A", "AD_开机零点范围[0-100]无效"),
    AD_滤波强度无效("06001B", "AD_滤波强度[0-3]无效"),
    AD_满量程无效("06001C", "AD_满量程[0-16777215]无效"),
    AD_满量程精度无效("06001D", "AD_满量程精度[0-3]无效"),
    AD_双分度切换点无效("06001C", "AD_双分度切换点[0-16777215]无效"),
    AD_分度值无效("06001C", "AD_分度值[0-10]无效"),
    AD_发送模式无效("06001C", "AD_发送模式无效"),
    AD_进入退出标定无效("06001D", "AD_进入退出标定无效"),
    AD_标定重量无效("06001E", "AD_标定重量无效"),
    AD_重力加速度系数无效("06001F", "AD_重力加速度系数[95000-105000]无效"),

    AD_背光开关无效("060020", "AD_背光开关无效"),
    AD_背光板数值无效("060021", "AD_背光板数值无效"),

    AD_温度补偿开关无效("060022", "AD_温度补偿开关无效"),
    AD_温度补偿进出无效("060023", "AD_温度补偿进出无效"),

    AD_未初始化回调监听("060024", "AD_未初始化回调监听"),
    AD_固件升级未握手("060025", "AD_固件升级未握手"),

    AD_读取重力加速度系数失败("060026", "AD_读取重力加速度系数失败"),
    AD_协议版本不存在("060027", "AD_协议版本不存在"),
    AD_响应通道对象异常("060028", "AD_响应通道对象异常"),

    AD_读取内码解析失败("060029", "AD_读取内码解析失败"),
    AD_秤台通讯初始化异常("06002A", "AD_秤台通讯初始化异常"),
    AD_显示通讯协议未配置("06002B", "AD_显示通讯协议未配置"),

//    AD_解析失败("0601F", "AD_AD码解码失败"),

    /**
     * @description: 07XXXX - 打印错误信息
     **/
    无效打印类型("070001", "无效打印类型"),
    图片源文件为空("070002", "图片源文件为空"),
    图片执行器不存在("070003", "图片执行器不存在"),
    创建保存文件失败("070004", "创建保存文件失败"),
    点图处理方式无效("070005", "点图处理方式无效"),
    Dither算法不存在("070006", "Dither算法不存在"),
    Dither临界值不存在("070007", "Dither临界值不存在"),
    Dither算法无效("070008", "Dither算法无效"),
    Color临界点百分比不存在("070009", "Color临界点百分比不存在"),
    响应对象反射异常("07000A", "响应对象反射异常"),
    响应体不存在("07000B", "响应体不存在"),
    响应体无效("07000C", "响应体无效"),
    起始结束标志无效("07000D", "起始结束标志无效"),
    超出缓冲极限("07000E", "超出缓冲极限"),
    CRC校验失败("07000F", "CRC校验失败"),
    超出缓冲极限同时CRC校验失败("070010", "超出缓冲极限同时CRC校验失败"),
    未识别的状态码("070011", "未识别的状态码"),
    收发长度不相同("070012", "收发长度不相同"),
    文件名无效("070013", "文件名无效"),
    位图文件名无效("070014", "位图文件名无效"),
    字库文件名无效("070015", "字库文件名无效"),
    固件文件名无效("070016", "固件文件名无效"),
    无效条码类型("070017", "无效条码类型"),
    边框像素不合法("070018", "边框像素不合法"),
    参数不支持("070019", "参数不支持"),
    打印缺纸("07001A", "打印缺纸"),
    打印过热("07001B", "打印过热"),
    解析模板无效("07001C", "解析模板无效"),
    模板片段无效("07001D", "模板片段无效"),
    打印模板数据未设置("07001E", "打印模板数据未设置"),
    模板片段不存在("07001F", "模板片段不存在"),
    通讯组件未初始化("070020", "通讯组件未初始化"),
    通讯组件D未初始化("070020", "通讯组件Default未初始化"),
    通讯组件A未初始化("070020", "通讯组件A未初始化"),
    通讯组件B未初始化("070020", "通讯组件B未初始化"),
    通讯超时("070021", "通讯超时"),
    系统异常_V1("070022", "系统异常V1"),
    系统异常_V2("070022", "系统异常V2"),
    打印升级保护失败("070023", "打印升级保护失败"),
    无效升级文件检查("070024", "无效升级文件检查"),
    字库未升级成功("070025", "字库未升级成功"),
    版本未升级成功("070026", "版本未升级成功"),
    打印部件不能为空("070027", "打印部件不能为空"),
    实时位图使用专用接口("070028", "实时位图使用专用接口"),
    打印部件缓冲区为空("070029", "打印部件缓冲区为空"),
    标签纸异常("07002A", "标签纸异常"),
    打印机未关闭("07002B", "打印机未关闭"),
    标签纸未拿走("07002C", "标签纸未拿走"),
    控制器不存在("07002D", "控制器不存在"),
    通讯设备不存在("07002E", "通讯设备不存在"),
    打印模块未初始化("07002F", "打印模块未初始化"),
    行模式不能为空("070030", "行模式不能为空"),

    /**
     * @description: 08XXXX - MQTT协议错误信息
     **/
    填充字段错误("080001", "加密填充错误"),
    MQTT_AES密钥不存在("080002", "密钥不存在"),
    MQTT_AES加密失败("080003", "AES加密失败"),
    MQTT_AES解密失败("080004", "AES解密失败"),
    MQTT_CRC检查错误("080005", "CRC检查失败"),
    MQTT客户端信息不存在("080006", "MQTT客户端信息不存在"),
    MQTT_Mark信息不存在("080007", "MQTT_Mark信息不存在"),
    MQTT指令信息不存在("080008", "MQTT指令信息不存在"),
    MQTT指令类型不存在("080009", "MQTT指令类型不存在"),
    MQTT指令类型未添加("08000A", "MQTT指令类型未添加"),
    MQTT内容指令与类型不配("08000B", "MQTT内容指令与类型不配"),
    MQTT数据包格式不正确("08000C", "MQTT数据包格式不正确"),
    MQTT解析数据包不存在("08000D", "MQTT解析数据包不存在"),
    MQTT数据包不存在("08000E", "MQTT数据包信息不存在"),
    MQTT数据包错误("08000F", "MQTT数据包错误"),
    模块信息加载失败("080010", "模块信息加载失败"),
    Mark解析失败("080011", "Mark解析失败"),

    /**
     * @description: 09XXXX - 蓝牙通讯协议异常
     **/
    升级握手失败("090001", "升级握手失败"),
    升级握手超时("090002", "升级握手超时"),
    未完成升级握手("090003", "未完成升级握手"),

    /**
     * @description: 0AXXXX - 蓝牙通讯协议异常
     **/
    AES_KEY_不存在("0A0001", "AES_KEY_不存在"),

    /**
     * @description: 0BXXXX - 交易异常
     **/
    交易未创建("0B0001", "交易未创建"),
    商品未选择("0B0002", "商品未选择"),
    规则不允许添加累计("0B0003", "规则不允许添加累计"),
    所属PLU的单位不被系统允许("0B0004", "所属PLU的单位不被系统允许"),
    商品条码信息不合法("0B0005", "商品条码信息不合法"),
    条码格式13位且本机商品价格为0不合法("0B0006", "条码格式13位，且本机商品价格为0，不合法"),// 条码格式，商品单价 不兼容,
    内部条码无效不允许添加("0B0007", "内部条码无效不允许添加"),
    数重量无效不允许添加("0B0008", "数重量无效不允许添加"),
    单计计算错误不允许添加("0B0009", "单计计算错误不允许添加"),
    重量单位无效不允许交易("0B000A", "重量单位无效不允许交易"),
    重量单位不明确不允许交易("0B000B", "重量单位不明确不允许交易"),
    商品单位与重量单位不兼容不允许交易("0B000B", "商品单位与重量单位不兼容不允许交易"),
    重量需要返回零点("0B000C", "重量需要返回零点"),

    /**
     * @description: 0CXXXX - TCP UDP Server通讯
     **/
    TCP_Server开启查找异常("0C0001", "TCP_Server开启查找异常"),
    TCP_Server关闭查找异常("0C0002", "TCP_Server关闭查找异常"),
    TCP_Server打开失败("0C0003", "TCP_Server打开失败"),
    TCP_Server不支持直接写("0C0004", "TCP_Server不支持直接写"),
    TCP_Server不支持直接读("0C0005", "TCP_Server不支持直接读"),
    TCP_Server通讯异常("0C0006", "TCP_Server通讯异常"),
    TCP_Server不支持IO输出流("0C0007", "TCP_Server不支持IO输出流"),
    TCP_Server不支持IO输入流("0C0008", "TCP_Server不支持IO输入流"),
    TCP_Client打开失败("0C0009", "TCP_Client打开失败"),
    TCP_Client获取输入流("0C00A", "TCP_Client获取输入流"),
    TCP_Client获取输出流("0C0000B", "TCP_Client获取输出流"),
    TCP_Client关闭失败("0C000C", "TCP_Client关闭失败"),
    UDP打开失败("0C000D", "UDP打开失败"),
    UDP不支持IO输出流("0C000E", "UDP不支持IO输出流"),
    UDP不支持IO输入流("0C000F", "UDP不支持IO输入流"),
    UDP写数据失败("0C0010", "UDP写数据失败"),
    UDP读数据失败("0C0011", "UDP读数据失败"),
    TCP_Client通讯失败("0C0012", "TCP_Client通讯失败"),
    TCP_Client未打开("0C0013", "TCP_Client未打开"),
    TCP_Client发送数据包不存在("0C0014", "TCP_Client发送数据包不存在"),
    TCP_Server_Client获取输入流("0C0015", "TCP_Server_Client获取输入流"),
    TCP_Server_Client获取输出流("0C0016", "TCP_Server_Client获取输出流"),
    TCP_Server_Client关闭失败("0C0017", "TCP_Server_Client关闭失败"),

    /**
     * @description: ODXXXX - loRa业务异常
     **/
    LoRa发送响应超时("0D0001", "LoRa发送响应超时"),


    /**
     * @description: 0EXXXX - BLE Print错误信息
     **/
    BP指令不存在("0E0001", "BP指令不存在"),
    BP响应指令无效("0E0002", "BP响应指令无效"),
    BP数据包格式错误("0E0003", "BP数据包格式错误"),
    BP数据包头无效("0E0004", "BP数据包头无效"),
    BP数据包尾无效("0E0005", "BP数据包尾无效"),
    BP数据包长度检查错误("0E0006", "BP数据包长度检查错误"),
    BP校验码无效("0E0007", "BP校验码无效"),
    BP数据格式错误("0E0008", "BP数据格式错误"),
    BP_操作结果解析失败("0E0009", "BP_操作结果解析失败"),
    BP_响应通道对象异常("06000A", "BP_响应通道对象异常"),
    BP_版本号读取解析失败("06000B", "BP_版本号读取解析失败"),
    BP条码格式不存在("06000C", "BP条码格式不存在"),
    BP数据参数不存在("06000D", "BP数据参数不存在"),
    BP打印格式不存在("06000E", "BP打印格式不存在"),
    BP商品信息不存在("06000F", "BP商品信息不存在"),
    BP条码格式内容不存在("060010", "BP条码格式内容不存在"),
    BP文本参数不存在("060011", "BP文本参数不存在"),
    BP打印格式内容不存在("060012", "BP打印格式内容不存在"),
    BP_发送模式无效("060013", "BP_发送模式无效"),
    BP_指令状态无效("060014", "BP_指令状态无效"),

    /**
     * @description: 0FXXXX - 天平错误信息
     **/
    TP指令不存在("0F0001", "TP指令不存在"),
    TP响应指令无效("0F0002", "TP响应指令无效"),
    TP数据包格式错误("0F0003", "TP数据包格式错误"),
    TP数据包头无效("0F0004", "TP数据包头无效"),
    TP数据包尾无效("0F0005", "TP数据包尾无效"),
    TP数据包长度检查错误("0F0006", "TP数据包长度检查错误"),
    TP校验码无效("0F0007", "TP校验码无效"),
    TP请求中稍后再试("0F0008", "TP请求中稍后再试"),
    TP初始化握手失败("0F0009", "TP初始化握手失败"),

    /**
     * @description: 10XXXX - 电子铅封错误信息
     **/
    SL_指令不支持("100001", "SL_指令不支持"),
    SL_指令不存在("100002", "SL_指令不存在"),
    SL_数据格式错误("100003", "SL_数据格式错误"),
    SL_CRC检查错误("100004", "SL_CRC检查错误"),
    ;
    private String code;

    private String msg;

    MeterStateEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
