package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.BlueDevice;
import com.jhscale.meter.protocol.model.ReadResponse;

/**
 * @author lie_w
 * @title: BluetoothPort
 * @projectName jh-meter
 * @description: 蓝牙通讯
 * @date 2021/6/412:48
 */
public class BluetoothPort extends PortManager<BlueDevice> {
    public static final String TAG = "BTPort";

    public BluetoothPort(DeviceControl control, DeviceDiscoverEventListener discoverEventListener) throws MeterException {
        super(control, discoverEventListener);
    }

    public BluetoothPort(DeviceControl control, BlueDevice device) throws MeterException {
        super(control, device);
    }

    public BluetoothPort(DeviceControl control, BlueDevice device, DeviceClientEventListener clientEventListener) throws MeterException {
        super(control, device, clientEventListener);
    }

    /**
     * @description: 开启发现
     **/
    @Override
    public boolean discovery() throws MeterException {
        try {
            return super.discovery();
        } catch (MeterException e) {
            JLog.error("{} discovery [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.蓝牙开启查找异常);
        }
    }

    /**
     * @description: 关闭发现 清空
     **/
    @Override
    public boolean cancelDiscovery(boolean clear) throws MeterException {
        try {
            return super.cancelDiscovery(clear);
        } catch (MeterException e) {
            JLog.error("{} cancelDiscovery [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.蓝牙关闭查找异常);
        }
    }

    @Override
    public boolean openPort() throws MeterException {
        try {
            return super.openPort();
        } catch (Exception e) {
            JLog.error("{} open [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.蓝牙打开失败);
        }
    }

    @Override
    public void writeDataImmediately(byte[] bytes, int offset, int len) throws MeterException {
        try {
            super.writeDataImmediately(bytes, offset, len);
        } catch (MeterException e) {
            JLog.error("{} write [ {} ] error：{}", TAG, this.portname(), e.getMessage());
            throw new MeterException(MeterStateEnum.蓝牙写入错误);
        }
    }

    @Override
    public ReadResponse readData(byte[] bytes) throws MeterException {
        try {
            return super.readData(bytes);
        } catch (MeterException e) {
            JLog.error("{} read [ {} ] error：{}", TAG, this.portname(), e.getMessage());
            throw new MeterException(MeterStateEnum.蓝牙读取错误);
        }
    }
}
