package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.TCPClientDevice;

/**
 * @author lie_w
 * @title: TCPServer
 * @projectName meter-jar
 * @description: TCP客户端连接 默认超时10s (同步请求)
 * @date 2022/12/309:52
 */
public class TCPClient extends PortManager<TCPClientDevice> {

    public static final String TAG = "TCPClient";

    public TCPClient() {
    }

    public TCPClient(SocketControl control, TCPClientDevice device) throws MeterException {
        super(control, device);
        super.time_out(120000);// 默认超时时间2分钟
    }

    /**
     * @description: 打开端口 (Override)
     **/
    @Override
    public boolean openPort() throws MeterException {
        try {
            return super.openPort();
        } catch (Exception e) {
            JLog.error("{} open [ {} ] error：{}", TAG, super.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.TCP_Client打开失败);
        }
    }


    /**
     * @description: 关闭端口 (Override)
     **/
    @Override
    public boolean closePort() throws MeterException {
        if (!this.isStatus()) return true;
        this.getControl().close();
        this.setStatus(false);
        if (this.getClientEventListener() != null) {
            this.getClientEventListener().stop();
        }
        return true;
    }
}
