package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.TCPServerDevice;

/**
 * @author lie_w
 * @title: TCPServer
 * @projectName meter-jar
 * @description: TCP服务端 默认超时时间5min (同步请求)
 * @date 2022/12/309:52
 */
public class TCPServer extends PortManager<TCPServerDevice> {

    public static final String TAG = "TCPServer";

    public TCPServer() {
    }

    public TCPServer(SocketControl control, TCPServerDevice device) throws MeterException {
        super(control, device);
        super.time_out(120000);// 默认2分钟没有数据包断开连接
    }

    public TCPServer(SocketControl control, TCPServerDevice device, DeviceClientEventListener clientEventListener) throws MeterException {
        super(control, device, clientEventListener);
        super.time_out(120000);// 默认2分钟没有数据包断开连接
    }

    @Override
    public boolean discovery() throws MeterException {
        try {
            return super.discovery();
        } catch (MeterException e) {
            JLog.error("{} discovery [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.TCP_Server开启查找异常);
        }
    }

    @Override
    public boolean cancelDiscovery(boolean clear) throws MeterException {
        try {
            return super.cancelDiscovery(clear);
        } catch (MeterException e) {
            JLog.error("{} cancelDiscovery [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.TCP_Server关闭查找异常);
        }
    }

    @Override
    public boolean openPort() throws MeterException {
        try {
            return super.openPortAddEventListenerBefore();
        } catch (Exception e) {
            JLog.error("{} open [ {} ] error：{}", TAG, super.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.TCP_Server打开失败);
        }
    }
}
