package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.ClientControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.TCPServerClientDevice;

/**
 * @author lie_w
 * @title: TCPServerClient
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/230:30
 */
public class TCPServerClient extends PortManager<TCPServerClientDevice> {

    public static final String TAG = "TCPServerClient";

    public TCPServerClient() {
    }

    public TCPServerClient(ClientControl control, TCPServerClientDevice device) throws MeterException {
        super(control, device);
    }

    public TCPServerClient(ClientControl control, TCPServerClientDevice device, DeviceClientEventListener clientEventListener) throws MeterException {
        super(control, device, clientEventListener);
    }

    public TCPServerClient(ClientControl control, TCPServerClientDevice device, PortManager portManager) throws MeterException {
        super(control, device, portManager);
    }

    /**
     * @description: 打开端口 (Override)
     **/
    @Override
    public boolean openPort() throws MeterException {
        TCPServerClientDevice device = getDevice();
        try {
            if (device == null) return false;
            if (this.isStatus()) return true;
            this.getControl().openPort(device);
            this.setStatus(this.getInputStream() != null && this.getOutputStream() != null);
            thread = new ClientThread((ClientControl) getControl());
            thread.start();
            return this.isStatus();
        } catch (Exception e) {
            JLog.error("{} open [ {} ] error：{}", TAG, super.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.TCP_Server打开失败);
        }
    }
}
