package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.model.ReadResponse;
import com.jhscale.meter.protocol.model.SocketReadResponse;

import java.util.Arrays;

/**
 * @author wang lie
 * @title: UDPPort
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/1/1816:01
 */
public class UDPLink extends PortManager<UDPDevice> {

    public static final String TAG = "UDP";

    public UDPLink() {
    }

    public UDPLink(SocketControl control, UDPDevice device, DeviceClientEventListener clientEventListener) throws MeterException {
        super(control, device, clientEventListener);
    }

    /**
     * @description: 打开端口 (Override)
     **/
    @Override
    public boolean openPort() throws MeterException {
        try {
            return super.openPortAddEventListenerBefore();
        } catch (Exception e) {
            JLog.error("{} open [ {} ] error：{}", TAG, super.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.UDP打开失败);
        }
    }

    /**
     * @param bytes
     * @param offset
     * @param len
     * @description: 流写出 (Override)
     */
    @Override
    public void writeDataImmediately(byte[] bytes, int offset, int len) throws MeterException {
        try {
            byte[] send = Arrays.copyOfRange(bytes, offset, len);
            this.write_log(send);
            ((SocketControl) this.getControl()).write(send);
        } catch (MeterException e) {
            throw e;
        } catch (Exception ep) {
            throw new MeterException(MeterStateEnum.UDP写数据失败);
        }
    }

    /**
     * @param bytes
     * @description: 读取字节流 (Override)
     */
    @Override
    public ReadResponse readData(byte[] bytes) throws MeterException {
        try {
            bytes = bytes == null ? new byte[1024] : bytes;
            SocketReadResponse response = ((SocketControl) this.getControl()).read(bytes);
            this.read_log(bytes, response.getLength());
            return response;
        } catch (Exception e) {
            throw new MeterException(MeterStateEnum.UDP读数据失败);
        }
    }
}
