package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.InitDeviceEntity;
import com.jhscale.meter.model.device.USBDevice;
import com.jhscale.meter.protocol.model.ReadResponse;

/**
 * @author lie_w
 * @title: USBPort
 * @projectName jh-meter
 * @description: USB 通讯
 * @date 2021/6/412:48
 */
public class USBPort extends PortManager<USBDevice> {
    public static final String TAG = "USB";

    public USBPort(DeviceControl control, DeviceDiscoverEventListener discoverEventListener) throws MeterException {
        super(control, discoverEventListener);
        super.initPort(new InitDeviceEntity());
    }

    public USBPort(DeviceControl control, USBDevice device) throws MeterException {
        super(control, device);
    }

    public USBPort(DeviceControl control, USBDevice device, DeviceClientEventListener clientEventListener) throws MeterException {
        super(control, device, clientEventListener);
    }

    @Override
    public boolean discovery() throws MeterException {
        try {
            return super.discovery();
        } catch (MeterException e) {
            JLog.error("{} discovery [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.USB开启查找异常);
        }
    }

    @Override
    public boolean cancelDiscovery(boolean clear) throws MeterException {
        try {
            return super.cancelDiscovery(clear);
        } catch (MeterException e) {
            JLog.error("{} cancelDiscovery [ {} ] error：{}", TAG, this.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.USB关闭查找异常);
        }
    }

    @Override
    public boolean openPort() throws MeterException {
        try {
            return super.openPort();
        } catch (Exception e) {
            JLog.error("{} open [ {} ] error：{}", TAG, super.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.USB打开失败);
        }
    }

    @Override
    public void writeDataImmediately(byte[] bytes, int offset, int len) throws MeterException {
        try {
            super.writeDataImmediately(bytes, offset, len);
        } catch (MeterException e) {
            JLog.error("{} write [ {} ] error：{}", TAG, super.portname(), e.getMessage());
            throw new MeterException(MeterStateEnum.USB写入错误);
        }
    }

    @Override
    public ReadResponse readData(byte[] bytes) throws MeterException {
        try {
            return super.readData(bytes);
        } catch (MeterException e) {
            JLog.error("{} read [ {} ] error：{}", TAG, super.portname(), e.getMessage());
            throw new MeterException(MeterStateEnum.USB读取错误);
        }
    }
}
