package com.jhscale.meter.io.control;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.model.device.InitDeviceEntity;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Set;

/**
 * @author lie_w
 * @title: DeviceControl
 * @projectName meter-jar
 * @description: 设备控制器
 * @date 2021/6/616:15
 */
public interface DeviceControl<T extends Device> {

    /**
     * @description: 初始化设备控制器
     */
    default void initDevice() throws MeterException {
    }

    /**
     * @description: 初始化控制器参数
     **/
    default void initParam(InitDeviceEntity entity) {
    }

    /**
     * @description: 添加查找监听
     **/
    void addListener(DeviceDiscoverEventListener discoverEventListener, Set<T> devicesDiscovered);

    /**
     * @description: 开启查找
     **/
    boolean discovery() throws MeterException;

    /**
     * @description: 关闭查找
     **/
    boolean cancelDiscovery() throws MeterException;

    /**
     * @description: 开启连接
     **/
    void openPort(T device) throws MeterException;

    /**
     * @description: 添加连接后监听器
     **/
    void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException;

    /**
     * @description: 输出流
     **/
    InputStream getInputStream() throws MeterException;

    /**
     * @description: 输入流
     **/
    OutputStream getOutputStream() throws MeterException;

    /**
     * @description: 关闭操作
     **/
    void close() throws MeterException;

    /**
     * @description: 连接检查
     **/
    boolean checkLink();


    /********************************************************************************/
}
