package com.jhscale.meter.io.control;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.model.SocketReadResponse;

import java.util.Set;

/**
 * @author wang lie
 * @title: SocketControl
 * @projectName meter-jar
 * @description: 套接字控制器
 * @date 2023/1/1817:25
 */
public interface SocketControl<T extends Device> extends DeviceControl<T> {

    /**
     * @param discoverEventListener
     * @param devicesDiscovered
     * @description: 添加查找监听
     */
    @Override
    default void addListener(DeviceDiscoverEventListener discoverEventListener, Set<T> devicesDiscovered) {
    }

    /**
     * @description: 开启查找
     **/
    @Override
    default boolean discovery() throws MeterException {
        return false;
    }

    /**
     * @description: 关闭查找
     **/
    @Override
    default boolean cancelDiscovery() throws MeterException {
        return false;
    }

    /**
     * @param clientEventListener
     * @param portManager
     * @description: 添加连接后监听器
     */
    @Override
    default void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException {

    }

    /**
     * @description: 连接检查
     **/
    @Override
    default boolean checkLink() {
        return false;
    }

    /**
     * @description: 通讯控制器直接写出
     **/
    default void write(byte[] bytes) throws MeterException {
    }

    /**
     * @description: 通讯器直接读取
     **/
    default SocketReadResponse read(byte[] bytes) throws MeterException {
        return new SocketReadResponse(-1);
    }
}
