package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.model.device.TCPClientDevice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

/**
 * @author lie_w
 * @title: WTCPServerControl
 * @projectName meter-jar
 * @description: Win TCP 客户端 控制器
 * @date 2022/12/3010:09
 */
public class WTCPClientControl implements SocketControl<TCPClientDevice> {

    // 设备连接器
    private Socket socket;

    /**
     * @param device
     * @description: 开启连接
     */
    @Override
    public void openPort(TCPClientDevice device) throws MeterException {
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(device.getIp(), device.getPort()), device.getTimeOut());
        } catch (IOException e) {
            throw new MeterException(MeterStateEnum.TCP_Client打开失败);
        }
    }

    /**
     * @description: 输出流
     **/
    @Override
    public InputStream getInputStream() throws MeterException {
        try {
            return this.socket.getInputStream();
        } catch (Exception e) {
            throw new MeterException(MeterStateEnum.TCP_Client获取输入流);
        }
    }

    /**
     * @description: 输入流
     **/
    @Override
    public OutputStream getOutputStream() throws MeterException {
        try {
            return this.socket.getOutputStream();
        } catch (Exception e) {
            throw new MeterException(MeterStateEnum.TCP_Client获取输出流);
        }
    }

    /**
     * @description: 关闭操作
     **/
    @Override
    public void close() throws MeterException {
        if (this.socket != null) {
            try {
                this.socket.close();
            } catch (IOException e) {
                throw new MeterException(MeterStateEnum.TCP_Client关闭失败);
            }
            this.socket = null;
        }
    }
}
