package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.ClientControl;
import com.jhscale.meter.model.device.TCPServerClientDevice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

/**
 * @author lie_w
 * @title: WServerClient
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/2223:42
 */
public class WTCPServerClientControl implements ClientControl<TCPServerClientDevice> {

    // 连接终端
    private Socket socket;

    /**
     * @description: 连接检查
     **/
    @Override
    public boolean checkLink() {
        if (this.socket != null) {
            try {
                this.socket.sendUrgentData(0XFF);
                return true;
            } catch (IOException e) {
                // e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    /**
     * @param device
     * @description: 开启连接
     */
    @Override
    public void openPort(TCPServerClientDevice device) throws MeterException {
        this.socket = (Socket) device.getDeviceInfo();
    }

    /**
     * @description: 输出流
     **/
    @Override
    public InputStream getInputStream() throws MeterException {
        try {
            return this.socket.getInputStream();
        } catch (Exception e) {
            // e.printStackTrace();
            throw new MeterException(MeterStateEnum.TCP_Server_Client获取输入流);
        }
    }

    /**
     * @description: 输入流
     **/
    @Override
    public OutputStream getOutputStream() throws MeterException {
        try {
            return this.socket.getOutputStream();
        } catch (Exception e) {
            // e.printStackTrace();
            throw new MeterException(MeterStateEnum.TCP_Server_Client获取输出流);
        }
    }

    /**
     * @description: 关闭操作
     **/
    @Override
    public void close() throws MeterException {
        if (this.socket != null) {
            try {
                this.socket.close();
            } catch (IOException e) {
                throw new MeterException(MeterStateEnum.TCP_Server_Client关闭失败);
            }
            this.socket = null;
        }
    }

    /**
     * @description: 获取地址信息
     **/
    @Override
    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    /**
     * @description: 获取端口号
     **/
    @Override
    public int getPort() {
        return this.socket.getPort();
    }
}
