package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.TCPServerClient;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.TCPServerClientDevice;
import com.jhscale.meter.model.device.TCPServerDevice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

/**
 * @author lie_w
 * @title: WTCPServerControl
 * @projectName meter-jar
 * @description: Win TCP 服务端 控制器
 * @date 2022/12/3010:09
 */
public class WTCPServerControl implements SocketControl<TCPServerDevice> {

    // 设备连接器
    private PortManager portManager;
    // 异步循环线程
    private WTCPServerThread thread;

    /**
     * @param device
     * @description: 开启连接
     */
    @Override
    public void openPort(TCPServerDevice device) throws MeterException {
        try {
            this.thread = new WTCPServerThread(this.portManager, new ServerSocket(device.getPort()));
            this.thread.start();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * @param clientEventListener
     * @param portManager
     * @description: 添加连接后监听器
     */
    @Override
    public void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException {
        this.portManager = portManager;
    }

    /**
     * @description: 输出流
     **/
    @Override
    public InputStream getInputStream() throws MeterException {
        return null;
        // throw new MeterException(MeterStateEnum.TCP_Server不支持IO输入流);
    }

    /**
     * @description: 输入流
     **/
    @Override
    public OutputStream getOutputStream() throws MeterException {
        return null;
        // throw new MeterException(MeterStateEnum.TCP_Server不支持IO输出流);
    }

    /**
     * @description: 关闭操作
     **/
    @Override
    public void close() throws MeterException {
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
    }

    /**
     * @description: TCP Server 异步线程
     **/
    private static class WTCPServerThread extends Thread {
        private final PortManager<TCPServerDevice> portManager;
        private ServerSocket serverSocket;

        WTCPServerThread(PortManager portManager, ServerSocket serverSocket) {
            super(String.format("%s_%s_Thread", portManager.getClass().getSimpleName(), System.currentTimeMillis()));
            this.portManager = portManager;
            this.serverSocket = serverSocket;
            // try {
            //     this.serverSocket.setSoTimeout(3600000);
            //     this.serverSocket.setReceiveBufferSize(1048576);
            // } catch (SocketException e) {
            //     throw new RuntimeException(e);
            // }
        }

        /**
         * If this thread was constructed using a separate
         * <code>Runnable</code> run object, then that
         * <code>Runnable</code> object's <code>run</code> method is called;
         * otherwise, this method does nothing and returns.
         * <p>
         * Subclasses of <code>Thread</code> should override this method.
         *
         * @see #start()
         * @see #stop()
         */
        @Override
        public void run() {
            while (!isInterrupted() && this.serverSocket != null) {
                try {
                    Socket socket = serverSocket.accept();
                    // 开启TCP Keepalive机制
                    // socket.setKeepAlive(true);
                    // 设置TCP Keepalive的时间间隔为60秒
                    // socket.setSoTimeout(600000);
                    // 发送缓冲区
                    socket.setSendBufferSize(1048576);
                    String socket_network = String.format("%s:%s", socket.getInetAddress().getHostAddress(), socket.getPort());
                    System.out.printf("客户端信息：%s%n", socket_network);

                    // socket.setKeepAlive(true);
                    // socket.setSoTimeout(5 * 1000);

                    // 检查连接状态
                    // while (!socket.isClosed() && socket.isConnected()) {
                    //     Thread.sleep(2000);
                    //     socket.getOutputStream().write(PUBLIC_LINE_SPLIT.getBytes());
                    //     // socket.sendUrgentData(0xff);
                    //     System.out.println(String.format("%s Date:[%s] isBound:[%s] isClosed:[%s] isConnected:[%s] isInputShutdown:[%s] isOutputShutdown[%s]",
                    //             socket_network, DateUtils.getString(new Date()), socket.isBound(), socket.isClosed(), socket.isConnected(), socket.isInputShutdown(), socket.isOutputShutdown()));
                    // }

                    TCPServerClient tcpServerClient = new TCPServerClient(new WTCPServerClientControl(),
                            new TCPServerClientDevice<>(socket_network, socket),
                            this.portManager);
                    tcpServerClient.openPort();

                } catch (SocketException e) {
                    System.err.printf("TCP Server Control: %s%n", e.getMessage());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /**
         * @description: 停止线程
         **/
        synchronized void close() {
            try {
                if (this.serverSocket != null) {
                    this.interrupt();
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
