package com.jhscale.meter.io.entity;

import com.jhscale.meter.exp.MeterStateEnum;

import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbPipe;
import java.io.IOException;
import java.io.OutputStream;

/**
 * @author lie_w
 * @title: EndpointOutputstream
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/6/710:42
 */
public class JEndpointOutputStream extends OutputStream {

    private UsbPipe usbPipe;

    public JEndpointOutputStream(UsbEndpoint usbEndpoint) throws UsbException {
        this.usbPipe = usbEndpoint.getUsbPipe();
        this.usbPipe.open();
    }

    /**
     * Writes the specified byte to this output stream. The general
     * contract for <code>write</code> is that one byte is written
     * to the output stream. The byte to be written is the eight
     * low-order bits of the argument <code>b</code>. The 24
     * high-order bits of <code>b</code> are ignored.
     * <p>
     * Subclasses of <code>OutputStream</code> must provide an
     * implementation for this method.
     *
     * @param b the <code>byte</code>.
     * @throws IOException if an I/O error occurs. In particular,
     *                     an <code>IOException</code> may be thrown if the
     *                     output stream has been closed.
     */
    @Override
    public void write(int b) throws IOException {
        try {
            usbPipe.syncSubmit(new byte[]{(byte) b});
        } catch (UsbException e) {
            throw new IOException(MeterStateEnum.USB_OUT输出异常.toString());
        }
    }

    /**
     * Closes this output stream and releases any system resources
     * associated with the stream.
     * <p>
     * The <code>close</code> method of <code>FilterOutputStream</code>
     * calls its <code>flush</code> method, and then calls the
     * <code>close</code> method of its underlying output stream.
     *
     * @throws IOException if an I/O error occurs.
     * @see java.io.FilterOutputStream#flush()
     * @see java.io.FilterOutputStream#out
     */
    @Override
    public void close() throws IOException {
        try {
            this.usbPipe.close();
            this.usbPipe = null;
        } catch (UsbException e) {
            throw new IOException(MeterStateEnum.USB_OUT关闭异常.toString());
        }
    }
}
