package com.jhscale.meter.io.entity;

import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.protocol.model.GlobalPara;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: TCPServerEntity
 * @projectName meter-jar
 * @description: tcp 服务端 对象信息
 * @date 2023/2/2214:48
 */
public class TCPServerEntity implements GJSONModel {

    // 通讯器
    private PortManager portManager;

    private ChannelHandlerContext ctx;

    public TCPServerEntity() {
    }

    public TCPServerEntity(PortManager portManager) {
        this.portManager = portManager;
    }

    public TCPServerEntity(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public PortManager getPortManager() {
        return portManager;
    }

    public void setPortManager(PortManager portManager) {
        this.portManager = portManager;
    }

    public ChannelHandlerContext getCtx() {
        return ctx;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    protected boolean writeData(String string) {
        try {
            if (StringUtils.isBlank(string)) string = DConstant.PUBLIC_LINE_SPLIT;
            if (GlobalPara.getInstance().isRunLog()) System.out.printf("TCP 异步写出内容：%n%s%n", string);
            if (Objects.nonNull(portManager)) {
                this.portManager.writeDataImmediately(string.getBytes(GlobalPara.getInstance().getProgram_encoding()));
                return true;
            } else if (Objects.nonNull(ctx)) {
                this.ctx.writeAndFlush(string).sync();
                return true;
            }
            return false;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
