package com.jhscale.meter.io.listener;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.IBProtocolResponse;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.entity.ProtocolEntity;

/**
 * @author lie_w
 * @title: DeviceClientEventListener
 * @projectName meter-jar
 * @description: 设备连接监听
 * @date 2021/6/615:51
 */
public interface DeviceClientEventListener {

    /**
     * @description: 连接监听
     **/
    default void onClientEvent(byte[] bytes) throws MeterException {
    }

    /**
     * @description: 默认回调器
     **/
    default IBProtocolResponse defaultResponse() {
        return null;
    }

    /**
     * @description: 连接异常监听
     **/
    void onClientEventExp(MeterException e);

    /**
     * @description: 发送命令添加回调
     **/
    default void addProtocolResponse(String key, ProtocolEntity entity) {
    }

    /**
     * @description: 设置通讯状态模式
     **/
    default void setCommunication(CommunicationState communication) {
    }

    /**
     * @description: 获取当前通讯协议状态
     **/
    default CommunicationState getCommunication() {
        return null;
    }

    /**
     * @description: 监听器停止
     **/
    default void stop() {
    }
}
