package com.jhscale.meter.io.listener;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.model.device.Device;

import java.util.Set;

/**
 * @author lie_w
 * @title: DeviceDiscoverEventListener
 * @projectName meter-jar
 * @description: 设备发现监听
 * @date 2021/6/615:49
 */
public interface DeviceDiscoverEventListener<T extends Device> {

    /**
     * @description: 发现监听事件
     **/
    void onDiscoverEvent(T device);

    /**
     * @param devicesDiscovered
     * @description: 完成设备查找 返回全部设备列表
     */
    void onDiscoverSuccessEvent(Set<T> devicesDiscovered);

    /**
     * @description: 查找设备异常
     **/
    void onDiscoverEventExp(MeterException e);
}
