package com.jhscale.meter.io.listener;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;

import java.net.InetAddress;

/**
 * @author lie_w
 * @title: DeviceClientEventListener
 * @projectName meter-jar
 * @description: 设备连接监听
 * @date 2021/6/615:51
 */
public interface SocketClientEventListener extends DeviceClientEventListener {

    /**
     * @param address 来源地址
     * @param port    来源端口
     * @param bytes   数据包
     * @description: UDP 连接监听（IP PORT）
     **/
    default byte[] onClientEvent(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException {
        return new byte[0];
    }

    /**
     * @description: TCP Client 连接监听（带响应回复）
     **/
    default byte[] onClientEventResponse(PortManager portManager, byte[] bytes) throws MeterException {
        return new byte[0];
    }

    /**
     * @param address
     * @param port
     * @description: TCP Server 连接监听
     */
    default void onClientLink(InetAddress address, int port) {
    }

    /**
     * @param address
     * @param port
     * @description: TCP Server断开监听
     */
    default void onClientBreak(InetAddress address, int port) {
    }
}
