package com.jhscale.meter.log;


/**
 * @author lie_w
 * @title: LogManager
 * @projectName meter
 * @description: TODO
 * @date 2021/6/410:18
 */
public class JLog {

    private static Log log = null;

    public interface Log {

        void info(String format, Object... arguments);

        void info(String msg, Throwable t);

        void debug(String format, Object... arguments);

        void debug(String msg, Throwable t);

        void warn(String format, Object... arguments);

        void warn(String msg, Throwable t);

        void error(String format, Object... arguments);

        void error(String msg, Throwable t);
    }

    private JLog(Log log) {
        this.log = log;
    }

    private static class Singleton {
        private static JLog manager = null;

        private static synchronized void init(Log log) {
            if (log != null && manager == null) manager = new JLog(log);
        }
    }

    /**
     * @description: 初始化
     */
    public static void init(Log log) {
        Singleton.init(log);
    }

    /**
     * @description: 获取单例对象
     */
    public static JLog getInstance() {
        return Singleton.manager;
    }

    public static void info(String format, Object... arguments) {
        if (log == null) return;
        log.info(format, arguments);
    }

    public static void info(String msg, Throwable t) {
        if (log == null) return;
        log.info(msg, t);
    }

    public static void debug(String format, Object... arguments) {
        if (log == null) return;
        log.debug(format, arguments);
    }

    public static void debug(String msg, Throwable t) {
        if (log == null) return;
        log.debug(msg, t);
    }

    public static void warn(String format, Object... arguments) {
        if (log == null) return;
        log.warn(format, arguments);
    }

    public static void warn(String msg, Throwable t) {
        if (log == null) return;
        log.warn(msg, t);
    }

    public static void error(String format, Object... arguments) {
        if (log == null) return;
        log.error(format, arguments);
    }

    public static void error(String msg, Throwable t) {
        if (log == null) return;
        log.error(msg, t);
    }
}
