package com.jhscale.meter.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author lie_w
 * @title: JavaLog
 * @projectName meter
 * @description: Java Log
 * @date 2021/6/410:35
 */
public class JavaLog implements JLog.Log {

    private static final Logger logger = LoggerFactory.getLogger(JavaLog.class);

    @Override
    public void info(String format, Object... arguments) {
        logger.info(format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        logger.info(msg, t);
    }

    @Override
    public void debug(String format, Object... arguments) {
        logger.debug(format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        logger.debug(msg, t);
    }

    @Override
    public void warn(String format, Object... arguments) {
        logger.warn(format, arguments);
    }

    @Override
    public void warn(String msg, Throwable t) {
        logger.warn(msg, t);
    }

    @Override
    public void error(String format, Object... arguments) {
        logger.error(format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        logger.error(msg, t);
    }
}
