package com.jhscale.meter.logistics;

import com.jhscale.meter.utils.ByteUtils;

import java.io.Serializable;
import java.util.Objects;

public class Agree implements Serializable, Comparable<Agree> {

    /**
     * 排序
     */
    private int order;

    /**
     * 协议名称
     */
    private String agreeName;

    /**
     * 长度
     */
    private int length;

    /**
     * 协议别名
     */
    private String nikeName;

    /**
     * 常用状态
     */
    private boolean state = false;

    /**
     * 数据包
     */
    private byte[] bytes;

    /**
     * 解析信息
     */
    private String result;

    public Agree() {
    }

    public Agree(byte[] bytes) {
        this.bytes = bytes;
    }

    public Agree(String agreeName, int length) {
        this.order = Integer.parseInt(agreeName.replace("协议", ""));
        this.agreeName = agreeName;
        this.length = length;
    }

    public Agree(String agreeName, int length, byte[] bytes) {
        this(agreeName, length);
        this.bytes = bytes;
    }

    public Agree(String agreeName, int length, String nikeName) {
        this(agreeName, length);
        this.nikeName = nikeName;
    }

    public Agree(String agreeName, int length, String nikeName, byte[] bytes) {
        this(agreeName, length, nikeName);
        this.bytes = bytes;
    }

    public Agree(String agreeName, int length, String nikeName, boolean state) {
        this(agreeName, length, nikeName);
        this.state = state;
    }

    public Agree(String agreeName, int length, String nikeName, boolean state, byte[] bytes) {
        this(agreeName, length, nikeName, state);
        this.bytes = bytes;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getAgreeName() {
        return agreeName;
    }

    public void setAgreeName(String agreeName) {
        this.agreeName = agreeName;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getNikeName() {
        return nikeName;
    }

    public void setNikeName(String nikeName) {
        this.nikeName = nikeName;
    }

    public boolean isState() {
        return state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    /**
     * Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.
     *
     * <p>The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)
     *
     * <p>The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.
     *
     * <p>Finally, the implementor must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.
     *
     * <p>It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     *
     * <p>In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of
     * <i>expression</i> is negative, zero or positive.
     *
     * @param o the object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     * is less than, equal to, or greater than the specified object.
     * @throws NullPointerException if the specified object is null
     * @throws ClassCastException   if the specified object's type prevents it
     *                              from being compared to this object.
     */
    @Override
    public int compareTo(Agree o) {
        if (o.getOrder() == this.order) {
            return 0;
        } else if (o.getOrder() < this.order) {
            return 1;
        } else {
            return -1;
        }
    }

    /**
     * @description: 协议检查
     **/
    public boolean check(byte[] bytes) {
        return Objects.nonNull(bytes) && bytes.length == this.length;
    }

    /**
     * @description: 拼装命令
     **/
    public StringBuffer assembler(String content) {
        return new StringBuffer();
    }

    /**
     * @description: 解析
     **/
    public String parse() {
        String result = ByteUtils.toHexAscii(this.bytes);
        if (check(this.bytes)) {
            result = ByteUtils.hex2Ascii(result);
        } else {
            result += " 数据包协议不正确";
        }
        this.result = result;
        return result;
    }
}
