package com.jhscale.meter.logistics;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author lie_w
 * @title: Test
 * @projectName jhscale-agreement
 * @description: 协议管理器
 * @date 2020/4/817:11
 */
public class LogAgree {

    /**
     * @description: 获取协议列表
     **/
    public static List<Agree> findAllLogAgree() {
        URL url = Agree.class.getResource("/");
        String fileName = url.getFile();
        String pathName = fileName.replaceFirst("/", "");
        File rootFile = new File(pathName);
        List<Agree> agrees = new ArrayList<>();
        setSubList(false, rootFile, rootFile.getPath() + "\\", Agree.class, agrees);
        Collections.sort(agrees);
        return agrees;
    }

    /**
     * @description: 获取协议列表
     **/
    public static List<Agree> findAllAgrees() {
        List<Agree> agrees = new ArrayList<>();
        try {
            for (int i = 1; i <= 20; i++) {
                Class<?> aClass = Class.forName("com.jhscale.meter.logistics.Agree" + i);
                Agree o = (Agree) aClass.newInstance();
                agrees.add(o);
            }
        } catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return agrees;
    }

    /**
     * @description: 获取协议列表
     **/
    public static List<Agree> findAllNormalAgrees() {
        List<Agree> agrees = new ArrayList<>();
        try {
            for (int i = 1; i <= 20; i++) {
                Class<?> aClass = Class.forName("com.jhscale.meter.logistics.Agree" + i);
                Agree o = (Agree) aClass.newInstance();
                if (o.isState())
                    agrees.add(o);
            }
        } catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return agrees;
    }

    /**
     * @description: 数据协议校验
     **/
    public static boolean check(Agree agree, byte[] bytes) {
        try {
            return agree.check(bytes);
        } catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    /**
     * @description: 查询子类 true - 包含 false - 不包含
     **/
    private static <T> void setSubList(boolean self, File rootFile, String parentDirectory, Class<T> parentClass, List<T> res) {
        if (rootFile.isDirectory()) {
            File[] files = rootFile.listFiles();
            for (File file : files) {
                setSubList(self, file, parentDirectory, parentClass, res);
            }
        } else {
            String className = null;
            try {
                if (rootFile.getPath().indexOf(".class") != -1) {
                    className = rootFile.getPath().replace(parentDirectory, "")
                            .replace(".class", "").replace("\\", ".");
                    Class<?> classObject = Class.forName(className);
                    classObject.asSubclass(parentClass);

                    // 要么是子类，要么是类本身
                    if (!className.equals(parentClass.getCanonicalName())) {
                        res.add((T) classObject.newInstance());
                    } else {
                        if (self) {
                            res.add((T) classObject.newInstance());
                        }
                    }
                }
            } catch (ClassNotFoundException | ClassCastException | IllegalAccessException | InstantiationException e) {
            }
        }
    }
}
