package com.jhscale.meter.lora;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.exp.MeterException;
import io.swagger.annotations.ApiModelProperty;

public class LoRaDevice extends JSONModel {

    @ApiModelProperty(value = "设备地址", name = "addr")
    private int addr = 0;
    @ApiModelProperty(value = "描述", name = "description")
    private String description = "";
    @ApiModelProperty(value = "固件版本", name = "firmware")
    private int firmware = 0;
    @ApiModelProperty(value = "固件日期(需要)", name = "firmwareDate_Need")
    private int firmwareDate_Need = 0;
    @ApiModelProperty(value = "固件日期(实际)", name = "firmwareDate_Current")
    private int firmwareDate_Current = 0;

    public LoRaDevice() {
    }

    public LoRaDevice(int addr, String description, int firmware, int firmwareDate_Need) {
        this.addr = addr;
        this.description = description;
        this.firmware = firmware;
        this.firmwareDate_Need = firmwareDate_Need;
    }

    public int ConvertNum2Date(int num) {
        int year = (num >> 9) & 0x7f;
        int month = (num >> 5) & 0x0f;
        int day = (num) & 0x1f;
        return year * 10000 + month * 100 + day;
    }

    public int ConvertDate2Num(int date) {
        int year = (date / 10000) % 100;
        int month = (date / 100) % 100;
        int day = date % 100;
        return (year << 9) + (month << 5) + day;
    }

    public boolean FirmwareIsOK(byte[] input) {
        int fm = (((int) input[0]) & 0xff) + (((int) input[1]) & 0xff) * 0x100 + (((int) input[2]) & 0xff) * 0x10000 + (((int) input[3]) & 0xff) * 0x1000000;
        int date = ConvertNum2Date((((int) input[4]) & 0xff) + (((int) input[5]) & 0xff) * 0x100);
        if (fm != this.firmware)
            return false;
        if (date < this.firmwareDate_Need)
            return false;
        this.firmwareDate_Current = date;
        return true;
    }

    public void CMD_Routine() {
        LoRaHost.getInstance().Send(
                new LoRaSend(this.addr, 0x807f, new byte[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',}, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        System.out.println(String.format("成功：[%s]", GJSONUtils.objectToJSON(receive)));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }

    public void Task_Routine() {
        ;
    }

    public void CMD_Version() {
        int addr = this.addr;
        LoRaDevice device = this;
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x8000, null, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        if (!device.FirmwareIsOK(receive.getData()))
                            System.out.println(String.format("失败：设备信息不匹配"));
                        else
                            System.out.println(String.format("成功：[%s]", GJSONUtils.objectToJSON(device)));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }

    public int getAddr() {
        return addr;
    }

    public String getDescription() {
        return description;
    }

    public int getFirmware() {
        return firmware;
    }

    public int getFirmwareDate_Need() {
        return firmwareDate_Need;
    }

    public int getFirmwareDate_Current() {
        return firmwareDate_Current;
    }

    public void setAddr(int addr) {
        this.addr = addr;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFirmware(int firmware) {
        this.firmware = firmware;
    }

    public void setFirmwareDate_Need(int firmwareDate_Need) {
        this.firmwareDate_Need = firmwareDate_Need;
    }

    public void setFirmwareDate_Current(int firmwareDate_Current) {
        this.firmwareDate_Current = firmwareDate_Current;
    }

}
