package com.jhscale.meter.lora;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.FileUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.exp.MeterException;
import io.swagger.annotations.ApiModelProperty;

import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoRaDevice_EZY extends LoRaDevice {

    @ApiModelProperty(value = "净重", name = "net")
    private BigDecimal net = BigDecimal.ZERO;
    @ApiModelProperty(value = "皮重", name = "tare")
    private BigDecimal tare = BigDecimal.ZERO;
    @ApiModelProperty(value = "总重", name = "gross")
    private BigDecimal gross = BigDecimal.ZERO;

    @ApiModelProperty(value = "单位", name = "unit")
    private String unit = "kg";
    @ApiModelProperty(value = "稳定", name = "isStable")
    private boolean stable = true;
    @ApiModelProperty(value = "零点", name = "isZero")
    private boolean zero = true;

    @ApiModelProperty(value = "错误状态", name = "error")
    private int error = 0;

    @ApiModelProperty(value = "允许标定", name = "isJP")
    private boolean isJP = false;

    @ApiModelProperty(value = "事件重量", name = "eventNet")
    private BigDecimal eventNet = null;
    @ApiModelProperty(value = "事件时间", name = "eventTime")
    private Long eventTime = null;
    @ApiModelProperty(value = "事件时长", name = "eventLast")
    private Integer eventLast = null;

    @ApiModelProperty(value = "事件缓冲位移", name = "eventBuf_Offset")
    private int eventBuf_Offset = 0;
    @ApiModelProperty(value = "事件缓冲", name = "eventBuf")
    private BigDecimal[] eventBuf = null;
    @ApiModelProperty(value = "事件累加等级", name = "eventLevel")
    private Integer eventLevel = null;

    private LoRaDevice_EZY LoRaWeightResult(byte[] input) {
        if (input.length < 5)
            return null;

        BigDecimal tempGross = null;
        BigDecimal tempTare = null;

        net = LoRaHost.GetNumS32(input, 0);
        stable = ((input[4] & 0x80) != 0);
        zero = ((input[4] & 0x40) != 0);
        //isTared=((input[4]&0x20)!=0);
        isJP = ((input[4] & 0x10) != 0);
        error = input[4] & 0x07;

        if (input.length < 6) {
            tare = new BigDecimal(0).movePointLeft(net.scale());
            gross = net;
        } else {
            int temp;
            temp = input[5] & 0x07;
            if (temp == 0)
                unit = "kg";
            else if (temp == 1)
                unit = "g";
            else if (temp == 2)
                unit = "ton";
            else if (temp == 3)
                unit = "lb";
            else if (temp == 4)
                unit = "oz";
            else if (temp == 5)
                unit = "ct";
            else //if(temp==6)
                unit = "kg";          //保留
//        else if(temp==7)
//            unit="kg";          //保留

            int pos = 6;

            if ((input[5] & 0x20) != 0) {
                tempTare = LoRaHost.GetNumS32(input, pos);
                pos += 4;
            }
            if ((input[5] & 0x10) != 0) {
                tempGross = LoRaHost.GetNumS32(input, pos);
                pos += 4;
            }

            if (tempTare == null) {
                if (tempGross == null) {
                    tare = new BigDecimal(0).movePointLeft(net.scale());
                    gross = net;
                } else {
                    gross = tempGross;
                    tare = gross.subtract(net);
                }
            } else {
                if (tempGross == null) {
                    tare = tempTare;
                    gross = tare.add(net);
                } else {
                    tare = tempTare;
                    gross = tempGross;
                }
            }

            if ((input[5] & 0x0f) != 0) {
                if (((input[5] & 0x0f) == 2) && (input.length >= pos + 5)) {
                    int eventType = input[pos];
                    if ((eventType & 0x01) == 0) {
                        eventLevel = (int) (input[pos + 1] & 0xff);
                        eventBuf = new BigDecimal[LoRaHost.GetU16(input, pos + 2)];
                        eventBuf_Offset = 0;
                        pos += 4;
                    } else
                        pos++;
                    while (input.length >= pos + 4) {
                        if (eventBuf_Offset < eventBuf.length) {
                            eventBuf[eventBuf_Offset] = LoRaHost.GetNumS32(input, pos);
                            eventBuf_Offset++;
                        }
                        pos += 4;
                    }
                    if ((eventType & 0x80) != 0) {
                        // todo 测试使用
                        String content = "";
                        content += "Level," + eventLevel.toString() + "\r\n";
                        content += "Lng," + Integer.toString(eventBuf_Offset) + "\r\n";
                        content += "Time," + Double.toString((eventBuf_Offset << eventLevel) / 320.0) + "s\r\n";
                        for (int i = 0; i < eventBuf_Offset; i++) {
                            content += Integer.toString(i) + "," + eventBuf[i].toString() + "\r\n";
                        }
                        Date date = new Date();
                        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
                        FileUtils.writer(content, new File("H:\\TEST", Integer.toString(getAddr()) + "_" + df.format(date) + ".csv"));
                        //end
                    }

                } else if (((input[5] & 0x0f) == 1) && (input.length >= pos + 8)) {
                    eventTime = System.currentTimeMillis() - LoRaHost.GetU16(input, pos) * 10;
                    eventLast = LoRaHost.GetU16(input, pos + 2);
                    eventNet = LoRaHost.GetNumS32(input, pos + 4);
                }
            }

        }

        return this;
    }

    public LoRaDevice_EZY(int addr, String description) {
        super(addr, description, 293, 230426);
    }

    @Override
    public void CMD_Routine() {
        CMD_Weight(2);
    }

    @Override
    public void Task_Routine() {
        Task_Weight(2);
    }

    public void CMD_Weight(Integer value) {
        int addr = this.getAddr();
        byte[] para = null;
        if (value != null)
            para = new byte[]{(byte) (value & 0xff)};
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x20, para, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        LoRaDevice_EZY object = LoRaWeightResult(receive.getData());
                        System.out.println(String.format("成功：[%s]", GJSONUtils.objectToJSON(object)));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }

    public void Task_Weight(Integer value) {
        int addr = this.getAddr();
        byte[] para = null;
        if (value != null)
            para = new byte[]{(byte) (value & 0xff)};
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x20, para, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        LoRaDevice_EZY object = LoRaWeightResult(receive.getData());
                        System.out.println(String.format("成功：[%s]", GJSONUtils.objectToJSON(object)));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                }, -1)
        );
    }

    public void CMD_Zero(boolean always) {
        int addr = this.getAddr();
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x81, new byte[]{(byte) (always ? 0x55 : 0x33)}, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        if ((receive.getData().length == 1) && (receive.getData()[0] == (byte) 0xaa))
                            System.out.println(String.format("成功：置零"));
                        else
                            System.out.println(String.format("失败：置零"));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }

    public void CMD_Tare(boolean always) {
        int addr = this.getAddr();
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x82, new byte[]{(byte) (always ? 0x55 : 0x33)}, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        if ((receive.getData().length == 1) && (receive.getData()[0] == (byte) 0xaa))
                            System.out.println(String.format("成功：去皮"));
                        else
                            System.out.println(String.format("失败：去皮"));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }

    public void CMD_Tare(BigDecimal tare, boolean always) {
        int addr = this.getAddr();
        int value = ByteUtils.toSPF(tare);
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x82, new byte[]{(byte) (always ? 0x55 : 0x33), (byte) (value & 0xff), (byte) ((value >> 8) & 0xff), (byte) ((value >> 16) & 0xff), (byte) ((value >> 24) & 0xff)}, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        if ((receive.getData().length == 1) && (receive.getData()[0] == (byte) 0xaa))
                            System.out.println(String.format("成功：去皮"));
                        else
                            System.out.println(String.format("失败：去皮"));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }

    public void CMD_Calibrate(BigDecimal weight, int wAll, int dot, int cAll, int unit, int degreeOffset) {
        int addr = this.getAddr();
        int value1 = ByteUtils.toSPF(weight);
        int value2 = (int) ((wAll << 3) | dot);
        byte[] output = new byte[14];
        output[0] = (byte) (value1 & 0xff);
        output[1] = (byte) ((value1 >> 8) & 0xff);
        output[2] = (byte) ((value1 >> 16) & 0xff);
        output[3] = (byte) ((value1 >> 24) & 0xff);
        output[4] = (byte) (value2 & 0xff);
        output[5] = (byte) ((value2 >> 8) & 0xff);
        output[6] = (byte) ((value2 >> 16) & 0xff);
        output[7] = (byte) ((value2 >> 24) & 0xff);
        output[8] = (byte) (cAll & 0xff);
        output[9] = (byte) ((cAll >> 8) & 0xff);
        output[10] = (byte) ((cAll >> 16) & 0xff);
        output[11] = (byte) ((cAll >> 24) & 0xff);
        output[12] = (byte) unit;
        output[13] = (byte) degreeOffset;
        LoRaHost.getInstance().Send(
                new LoRaSend(addr, 0x83, output, new LoRaResponse() {
                    @Override
                    public void response(LoRaReceive receive) {
                        if ((receive.getData().length == 1) && (receive.getData()[0] == (byte) 0xaa))
                            System.out.println(String.format("成功：标定"));
                        else
                            System.out.println(String.format("失败：标定"));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("请求异常：[%s]", e.getMessage()));
                    }
                })
        );
    }


}
