package com.jhscale.meter.lora;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModelProperty;

public class LoRaPara extends JSONModel {
    
    @ApiModelProperty(value = "频段编号(初始化)", name = "freqType_Init")
    private int freqType_Init = 0;
    @ApiModelProperty(value = "频段编号(实际值)", name = "freqType_Real")
    private int freqType_Real = 0;
    @ApiModelProperty(value = "发射功率", name = "power")
    private int power = 20;
    @ApiModelProperty(value = "信号带宽", name = "signalBw")
    private int signalBw = 8;
    @ApiModelProperty(value = "扩展因子", name = "spreadingFactor")
    private int spreadingFactor = 7;
    @ApiModelProperty(value = "误码率", name = "errorCoding")
    private int errorCoding = 1;
    @ApiModelProperty(value = "地址", name = "addr")
    private int addr = 1;
    @ApiModelProperty(value = "预留", name = "Rv")
    private int rv = 0;

    public void setFreqType(int freqType) {
        this.freqType_Init = this.freqType_Real = freqType;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public byte[] getPara(int addr) {
        byte[] output = new byte[8];
        output[0] = (byte) this.freqType_Real;
        output[1] = (byte) (this.freqType_Real >> 8);
        output[2] = (byte) this.power;
        output[3] = (byte) this.signalBw;
        output[4] = (byte) this.spreadingFactor;
        output[5] = (byte) this.errorCoding;
        output[6] = (byte) addr;
        output[7] = (byte) this.rv;
        return output;
    }
    public byte[] getPara() {
        return getPara(this.addr);
    }

    public boolean setPara(byte[] input) {
        if (input == null)
            return false;
        else if(input.length ==0)
            return true;
        else if(input.length < 8)
            return false;

        freqType_Real = (((int) input[0]) & 0xff) + (((int) input[1]) & 0xff) * 0x100;
        power = input[2];
        signalBw = input[3];
        spreadingFactor = input[4];
        errorCoding = input[5];
        addr = input[6];
        rv = input[7];
        return true;
    }

    public boolean checkPara(byte[] input) {
        if ((input == null) || (input.length < 8))
            return false;
        if (power != input[2])
            return false;
        if (signalBw != input[3])
            return false;
        if (spreadingFactor != input[4])
            return false;
        if (errorCoding != input[5])
            return false;
        if (addr != input[6])
            return false;
        if (rv != input[7])
            return false;
        if (freqType_Real != (((int) input[0]) & 0xff) + (((int) input[0]) & 0xff) * 0x100)
            return false;

        return true;
    }


}
