package com.jhscale.meter.lora;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: LoRaReceive
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/4/2715:40
 */
public class LoRaReceive extends JSONModel {

    @ApiModelProperty(value = "接收_数据地址(Q=256，R=0~31)", name = "received_Address")
    private int addr = 0;
    @ApiModelProperty(value = "接收_数据命令", name = "received_Command")
    private int cmd = 0;
    @ApiModelProperty(value = "接收_数据内容", name = "received_Data")
    private byte[] data = new byte[0];

    public LoRaReceive() {
    }

    public LoRaReceive(int received_Addr, int received_CMD, byte[] received_Data) {
        this.addr = received_Addr;
        this.cmd = received_CMD;
        this.data = received_Data;
    }

    public int getAddrCmd() {
        return addr * 0x10000 + cmd;
    }

    public int getAddr() {
        return addr;
    }

    public int getCmd() {
        return cmd;
    }

    public byte[] getData() {
        return data;
    }

    public void setAddr(int addr) {
        this.addr = addr;
    }

    public void setCmd(int cmd) {
        this.cmd = cmd;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}
