package com.jhscale.meter.lora;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: LoRaSendCache
 * @projectName meter-jar
 * @description: 发送对象
 * @date 2023/4/2715:59
 */
public class LoRaSend extends JSONModel {

    @ApiModelProperty(value = "合法数据", name = "valid")
    private boolean valid = false;

    @ApiModelProperty(value = "发送_数据地址", name = "addr")
    private int addr;
    @ApiModelProperty(value = "发送_数据命令", name = "cmd")
    private int cmd;
    @ApiModelProperty(value = "发送_数据内容", name = "send_Data")
    private byte[] data = new byte[0];

    @ApiModelProperty(value = "开始时间", name = "start")
    private long start = System.currentTimeMillis();
    @ApiModelProperty(value = "超时时间", name = "timeout")
    private int timeout = 1000;
    @ApiModelProperty(value = "响应结果信息", name = "response")
    private LoRaResponse response;

    private void LoRaSend_Init(int addr, int cmd, byte[] datas, LoRaResponse response, int timeout) {
        this.valid = true;
        this.addr = addr;
        this.cmd = cmd;
        this.response = response;
        this.timeout = timeout;
        if (addr > 255) {
            byte[] output;
            int dlng;
            if (datas == null)
                dlng = 0;
            else
                dlng = datas.length;
            output = new byte[5 + dlng];

            output[0] = (byte) 0xf2;
            output[1] = 'Q';
            output[2] = (byte) (1 + dlng);
            output[3] = (byte) cmd;
            output[4 + dlng] = (byte) 0xf3;
            for (int loop = 0; loop < dlng; loop++)
                output[4 + loop] = datas[loop];

            this.data = output;
        } else {
            byte[] output;
            int offset;
            if (addr > 31) {
                this.valid = false;
                return;
            }
            int dlng;
            if (datas == null)
                dlng = 0;
            else
                dlng = datas.length;

            if (cmd >= 0x80) {
                cmd -= 0x80;
                output = new byte[7 + dlng];
                output[4] = (byte) ((cmd & 0x7f) | 0x80);
                output[5] = (byte) (cmd >> 7);
                offset = 6;
            } else {
                output = new byte[6 + dlng];
                output[4] = (byte) cmd;
                offset = 5;
            }
            if (response != null)
                output[3] = (byte) (addr | 0x80);
            else
                output[3] = (byte) (addr | 0x40);
            output[0] = (byte) 0xf2;
            if (timeout < 0)
                output[1] = 'T';
            else
                output[1] = 'S';
            output[2] = (byte) (offset - 3 + dlng);
            output[offset + dlng] = (byte) 0xf3;
            for (int loop = 0; loop < dlng; loop++)
                output[offset + loop] = datas[loop];

            this.data = output;
        }
    }

    public LoRaSend(int addr, int cmd, byte[] datas, LoRaResponse response, int timout) {
        LoRaSend_Init(addr, cmd, datas, response, timout);
    }

    public LoRaSend(int addr, int cmd, byte[] datas, LoRaResponse response) {
        LoRaSend_Init(addr, cmd, datas, response, 1000);
    }

    public LoRaSend(int addr, int cmd, byte[] datas) {
        LoRaSend_Init(addr, cmd, datas, null, 1000);
    }

    public LoRaSend(byte[] input) {
        this.valid = true;
        this.addr = 0;
        this.cmd = 0;
        this.response = null;
        this.timeout = 0;
        this.data = input;
    }


//    public LoRaSend(boolean ack, int addr, int cmd, byte[] data, LoRaResponse response) {
//        this.ack = ack;
//        this.addr = addr;
//        this.cmd = cmd;
//        this.data = data;
//        this.response = response;
//    }

    public boolean isValid() {
        return valid;
    }

    public int getAddr() {
        return addr;
    }

    public int getCmd() {
        return cmd;
    }

    public int getAddrCmd() {
        return addr * 0x10000 + cmd;
    }

    public byte[] getData() {
        return data;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > start + timeout;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public LoRaResponse getResponse() {
        return response;
    }

}
