package com.jhscale.meter.lora.manager;//package com.jhscale.meter.lora.manager;
//
//import com.jhscale.common.utils.ByteUtils;
//import com.jhscale.meter.exp.MeterException;
//import com.jhscale.meter.exp.MeterStateEnum;
//import com.jhscale.meter.utils.SerialTool;
//import gnu.io.SerialPort;
//import gnu.io.SerialPortEvent;
//import gnu.io.SerialPortEventListener;
//
///**
// * @author lie_w
// * @title: DefaultLoraSerialMessage
// * @projectName meter-jar
// * @description: 默认通讯器
// * @date 2023/4/2620:48
// */
//public class WinLoRaSerialMessenger implements LoRaMessenger {
//
//    private String portName = "COM3";
//    private int baudrate = 9600;
//    private SerialPort serialPort;
//
//    private LoRaManagerNotify notify;
//
////    private LoRaRunnable runnable;// 发送线程
////    private LoRaManagerNotify notify;// 默认全局反馈
////    private List<LoRaManagerNotify> notifies;// 实时反馈
//
////    public WinLoRaSerialMessenger() {
////        this.notifies = new CopyOnWriteArrayList();
////    }
//
//    public WinLoRaSerialMessenger(String portName, int baudrate, LoRaManagerNotify notify) {
//        this.portName = portName;
//        this.baudrate = baudrate;
//        this.notify = notify;
//    }
//
//    /**
//     * @description: 打开通讯器
//     **/
//    @Override
//    public void open() throws MeterException {
//        this.serialPort = SerialTool.openPort(portName, baudrate);
//        SerialTool.addListener(this.serialPort, new SerialPortEventListener() {
//            @Override
//            public void serialEvent(SerialPortEvent serialPortEvent) {
//                switch (serialPortEvent.getEventType()) {
//                    case SerialPortEvent.BI: // 10 通讯中断
//                        break;
//                    case SerialPortEvent.OE: // 7 溢位（溢出）错误
//                        break;
//                    case SerialPortEvent.FE: // 9 帧错误
//                        break;
//                    case SerialPortEvent.PE: // 8 奇偶校验错误
//                        break;
//                    case SerialPortEvent.CD: // 6 载波检测
//                        break;
//                    case SerialPortEvent.CTS: // 3 清除待发送数据
//                        break;
//                    case SerialPortEvent.DSR: // 4 待发送数据准备好了
//                        break;
//                    case SerialPortEvent.RI: // 5 振铃指示
//                        break;
//                    case SerialPortEvent.OUTPUT_BUFFER_EMPTY: // 2 输出缓冲区已清空
//                        break;
//                    case SerialPortEvent.DATA_AVAILABLE: // 1 串口存在可用数据
//                        try {
//                            Thread.sleep(50);
//                        } catch (InterruptedException e) {
//                        }
//                        try {
//                            byte[] bytes = SerialTool.readFromPort(serialPort);
//                            System.out.println(String.format("打印串口接受数据：%s", ByteUtils.bytes2HexString(bytes)));
//                            // 常规响应 todo 不做响应默认回调超时 此处还需要缓冲区处理完整数据包 安卓底层可能存在分包接受的状况
//                            notify.response(identify(), bytes);
//                            // response(bytes);
//                        } catch (Exception e) {
//                            e.printStackTrace();
//                            notify.exp(identify(), e instanceof MeterException ? (MeterException) e : new MeterException(e, MeterStateEnum.串口读取错误));
//                            // 仪表异常信息
//                            // exp(e);
//                        }
//                        break;
//                }
//            }
//        });
//    }
//
////    /**
////     * @description: 响应异常
////     **/
////    private void exp(Exception e) {
////        LoRaNotifyChannel channel = this.notifyChannel();
////        if (channel != null && channel.getNotify() != null)
////            channel.getNotify().exp(this.identify(), e instanceof MeterException ? (MeterException) e : new MeterException(e, MeterStateEnum.串口读取错误));
////        if (channel != null && channel.isRequest() && this.runnable != null)
////            this.runnable.notify_success(this.identify());
////    }
////
////    /**
////     * @description: 响应异常 此处还需要缓冲区处理完整数据包 安卓底层可能存在分包接受的状况
////     **/
////    private void response(byte[] bytes) {
////        LoRaNotifyChannel channel = this.notifyChannel();
////        if (channel != null && channel.getNotify() != null) channel.getNotify().response(identify(), bytes);
////        if (channel != null && channel.isRequest() && this.runnable != null)
////            this.runnable.notify_success(this.identify());
////    }
//
////    /**
////     * @param notify
////     * @description: 添加默认回调器
////     */
////    @Override
////    public WinLoRaSerialMessenger addNotify(LoRaManagerNotify notify) {
////        this.notify = notify;
////        return this;
////    }
//
////    /**
////     * @param runnable
////     * @description: 添加发送线程 用于通知接受数据成功
////     */
////    @Override
////    public WinLoRaSerialMessenger addRunnable(LoRaRunnable runnable) {
////        this.runnable = runnable;
////        return this;
////    }
//
////    /**
////     * @description: 获取回调器
////     **/
////    @Override
////    public LoRaNotifyChannel notifyChannel() {
////        if (this.notifies != null && !this.notifies.isEmpty())
////            return new LoRaNotifyChannel(this.notifies.remove(0), true);
////        if (this.notify != null) return new LoRaNotifyChannel(this.notify, false);
////        return null;
////    }
//
//    /**
//     * @param bytes
//     * @description: 写数据
//     */
//    @Override
//    public void write(byte[] bytes) {
////        if (notify != null) this.notifies.add(notify);
//        long start1 = System.currentTimeMillis();
//        try {
//            SerialTool.sendToPort(this.serialPort, bytes);
//        } catch (MeterException e) {
//            e.printStackTrace();
//            this.notify.exp(this.identify(), e);
//        }
//        System.out.println("打印串口发送数据 耗时： " + (System.currentTimeMillis() - start1) + "； 数据内容：" + ByteUtils.bytes2HexString(bytes));
//    }
//
//    /**
//     * @description: 关闭通讯器
//     **/
//    @Override
//    public void close() {
//        this.serialPort.close();
//    }
//
//    /**
//     * @description: 通讯去编号标识(串口通讯, 串口号)
//     **/
//    @Override
//    public String identify() {
//        return this.portName;
//    }
//}
