package com.jhscale.meter.model.base;

import com.jhscale.common.utils.GJSONUtils;

import java.io.Serializable;

/**
 * @author lie_w
 * @title: JSONSerializable
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/6/1023:26
 */
public interface JSONMeter extends Serializable {

    /**
     * @description: 转JSON 字符串
     **/
    default String toJSON() {
        return GJSONUtils.objectToJSON(this);
    }

    /**
     * @description: JSON格式字符串
     **/
    default String toJSONParse() {
        return GJSONUtils.parseObject(this);
    }

    /**
     * @description: 对象转换
     **/
    default <T> T toObject(Class<T> clazz) {
        return GJSONUtils.objectToObject(this, clazz);
    }
}
