package com.jhscale.meter.model.device;

/**
 * @author Loveven
 * @title: BlueInfo
 * @projectName meter-jar
 * @description: 蓝牙 设备
 * @date 2021-06-0422:25
 */
public class BlueDevice<T> extends Device {

    private long timestamp = System.currentTimeMillis();

    private String blueName;

    private boolean trusted;

    private boolean encrypted;

    private String remark;

    public BlueDevice() {
    }

    public BlueDevice(String device, String blueName) {
        super(device);
        this.blueName = blueName;
    }

    public BlueDevice(String device, T deviceInfo, String blueName, boolean trusted, boolean encrypted) {
        super(device, deviceInfo);
        this.blueName = blueName;
        this.trusted = trusted;
        this.encrypted = encrypted;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getBlueName() {
        return blueName;
    }

    public void setBlueName(String blueName) {
        this.blueName = blueName;
    }

    public boolean isTrusted() {
        return trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public boolean isEncrypted() {
        return encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
