package com.jhscale.meter.model.device;

import com.jhscale.meter.utils.MeterConstant;

/**
 * @author lie_w
 * @title: DeviceInit
 * @projectName meter-jar
 * @description: 初始化设备参数
 * @date 2021/6/621:39
 */
public class InitDeviceEntity {

    /**
     * @description: 默认读取长度
     **/
    private Integer streamLength = MeterConstant.DEFAULT_READ_STREAM_LENGTH; // 默认读取字节流长度

    /**
     * @description: USB 设备初始化参数
     **/
    private Short VID = MeterConstant.DEFAULT_VID;
    private Short PID = MeterConstant.DEFAULT_PID;

    public InitDeviceEntity() {
    }

    public InitDeviceEntity(short VID, short PID) {
        this.VID = VID;
        this.PID = PID;
    }

    public Integer getStreamLength() {
        return streamLength;
    }

    public void setStreamLength(Integer streamLength) {
        this.streamLength = streamLength;
    }

    public Short getVID() {
        return VID;
    }

    public void setVID(Short VID) {
        this.VID = VID;
    }

    public Short getPID() {
        return PID;
    }

    public void setPID(Short PID) {
        this.PID = PID;
    }
}
