package com.jhscale.meter.model.device;

/**
 * @author lie_w
 * @title: TCPServer
 * @projectName meter-jar
 * @description: TCP服务端设备
 * @date 2022/12/309:52
 */
public class TCPClientDevice<T> extends Device {

    // 客户端IP
    private String ip;

    // 客户端 模式 端口号
    private int port = 33582;

    // 连接默认超时时间
    private int timeOut = 10000;

    public TCPClientDevice() {
    }

    public TCPClientDevice(String ip) {
        this.ip = ip;
    }

    public TCPClientDevice(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public TCPClientDevice(String ip, int port, int timeOut) {
        this.ip = ip;
        this.port = port;
        this.timeOut = timeOut;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }
}
