package com.jhscale.meter.model.device;

import com.jhscale.common.utils.SystemtUtils;
import org.apache.commons.lang3.StringUtils;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * @author wang lie
 * @title: UDPDevice
 * @projectName meter-jar
 * @description: UDP通讯设备
 * @date 2023/1/1815:40
 */
public class UDPDevice<T> extends Device {

    // 监听端口
    private int listener;

    // 广播端口
    private int broadcast;

    // 广播地址
    private String broadcastAddress;

    public UDPDevice() {
    }

    public UDPDevice(int listener, int broadcast) {
        this.listener = listener;
        this.broadcast = broadcast;
    }

    /**
     * @description: 终端UDP通讯
     **/
    public static UDPDevice UDP_Terminal() {
        return new UDPDevice(33583, 33584);
    }

    /**
     * @description: PC UDP通讯
     **/
    public static UDPDevice UDP_PC() {
        return new UDPDevice(33584, 33583);
    }

    /**
     * @description: 广播地址
     **/
    public InetAddress broadcastAddress() {
        try {
            if (StringUtils.isNotBlank(this.broadcastAddress)) {
                return InetAddress.getByName(this.broadcastAddress);
            } else {
                return InetAddress.getByName(SystemtUtils.route_broadcast());
            }
        } catch (Exception e) {
            try {
                return InetAddress.getByName("255.255.255.255");
            } catch (UnknownHostException e1) {
            }
        }
        return null;
    }

    public int getListener() {
        return listener;
    }

    public void setListener(int listener) {
        this.listener = listener;
    }

    public int getBroadcast() {
        return broadcast;
    }

    public void setBroadcast(int broadcast) {
        this.broadcast = broadcast;
    }

    public String getBroadcastAddress() {
        return broadcastAddress;
    }

    public void setBroadcastAddress(String broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }
}
