package com.jhscale.meter.mqtt;

import com.jhscale.meter.log.JLog;
import com.jhscale.meter.mqtt.em.MQTTCMD;
import com.jhscale.meter.mqtt.entity.Mark;

import java.nio.charset.Charset;
import java.util.Objects;

/**
 * @author lie_w
 * @title: ICMD
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/110:50
 */
public class ICMD extends IMQTT {

    /**
     * @description: 具体CMD
     **/
    private MQTTCMD cmd;

    public ICMD() {
        this.cmd = MQTTCMD.mqttcmd(this.getClass());
    }

    public ICMD(Charset charset) {
        super(charset);
        this.cmd = MQTTCMD.mqttcmd(this.getClass());
    }

    public ICMD(String innerContent) {
        super(innerContent);
    }

    public ICMD(Charset charset, String innerContent) {
        super(charset, innerContent);
    }

    /**
     * @description: 内容体组装
     **/
    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .appendCmd(this.cmd.getCmd());
    }

    /**
     * @param mark
     * @description: 内容解析
     */
    public IMQTT unpackSubContent(Mark mark) {
        this.cmd = MQTTCMD.mqttcmd(super.parseCmd());
        if (Objects.nonNull(this.cmd)) {
            ICMD icmd = null;
            try {
                icmd = (ICMD) (mark.getAck().isRequest() ? this.cmd.getRequestClazz() : this.cmd.getResponseClazz()).newInstance();
                icmd.copy(this);
            } catch (InstantiationException | IllegalAccessException e) {
                JLog.error("Command Parse CMD Error:{}", this.cmd, e);
                return null;
            }
            icmd.fillingSub();
            super.copy(icmd);
            return icmd;
        } else {
            super.clear();
        }
        return null;
    }

    /**
     * @description: 解析填充
     **/
    @Override
    public void fillingSub() {
        super.fillingSub();
    }

    public MQTTCMD getCmd() {
        return cmd;
    }

    public void setCmd(MQTTCMD cmd) {
        this.cmd = cmd;
    }
}
