package com.jhscale.meter.mqtt;

import com.jhscale.meter.log.JLog;
import com.jhscale.meter.mqtt.data.DataResponse;
import com.jhscale.meter.mqtt.em.DCmd;
import com.jhscale.meter.mqtt.em.DSort;
import com.jhscale.meter.mqtt.entity.DMark;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MQTTUtils;

import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: IData
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/2112:30
 */
public class IDATA extends IMQTT {

    // 指令
    private DMark dmark;

    // 数据格式
    private DSort dsort;

    // DID
    private String did;

    // DDATA
    private String data;

    /**
     * @description: 组装构造函数
     **/
    public IDATA() {
    }

    public IDATA(DCmd cmd, Integer did) {
        this.dsort = DSort.sort(this.getClass());
        this.did = ByteUtils.convert(MQTTUtils.int2Hex(did));
        this.dmark = new DMark(cmd, this.dsort.getSort().length(), this.did.length());
    }

    public IDATA(Charset charset, DCmd cmd, Integer did) {
        super(charset);
        this.dsort = DSort.sort(this.getClass());
        this.did = ByteUtils.convert(MQTTUtils.int2Hex(did));
        this.dmark = new DMark(cmd, this.dsort.getSort().length(), this.did.length());
    }

    public IDATA(String innerContent) {
        super(innerContent);
    }

    public IDATA(Charset charset, String innerContent) {
        super(charset, innerContent);
    }

    /**
     * @description: 内容体组装
     **/
    @Override
    public IMQTT packSubContent() {
        return super.packSubContent();
    }

    /**
     * @description: 组装流
     **/
    public IMQTT packStream() {
        String dataSubContent = this.packSubContent().over();
        String lenSubContent = ByteUtils.convert(MQTTUtils.int2Hex((this.did.length() + this.dsort.getSort().length() + dataSubContent.length()) / 2));
        this.dmark.setLenl(lenSubContent.length());
        return super.packSubContent()
                .appendTopHex(this.did)
                .appendTopHex(ByteUtils.convertHex(this.dsort.getSort()))
                .appendTopHex(lenSubContent)
                .appendTopHex(this.dmark.assembleDMark());
    }

    /**
     * @param mark
     * @description: 内容解析
     */
    @Override
    public IMQTT unpackSubContent(Mark mark) {
        if (mark.getAck().isRequest()) {
            String buffer = super.getBuffer().toString();
            DMark dmark = new DMark(super.parseHex(2));
            int dlen = MQTTUtils.hex2Int(super.parseCovert(dmark.getLenl())) * 2;
            DSort sort = DSort.sort(super.parseCovert(dmark.getSortl()));
            String did = super.parseHex(dmark.getDidl());
            String discard = super.parseHex(dmark.datal(dlen));
            if (sort != null) {
                IDATA idata = null;
                try {
                    idata = (IDATA) sort.getClazz().newInstance();
                    idata.copy(super.getCharset(), discard);
                    idata.dmark = dmark;
                    idata.dsort = sort;
                    idata.did = did;
                    idata.data = buffer.substring(0, 2 + dmark.getLenl() + dlen);
                    idata.fillingSub();
                } catch (InstantiationException | IllegalAccessException e) {
                    JLog.error("Command Parse Data Error:{}", sort, e);
                    return null;
                }
                return idata;
            } else {
                JLog.warn("Command Parse Discard Data:{}", discard);
                return null;
            }
        } else {
            DataResponse response = new DataResponse();
            response.copy(this);
            response.fillingSub();
            super.copy(response);
            return response;
        }
    }

    public DMark getDmark() {
        return dmark;
    }

    public void setDmark(DMark dmark) {
        this.dmark = dmark;
    }

    public DSort getDsort() {
        return dsort;
    }

    public void setDsort(DSort dsort) {
        this.dsort = dsort;
    }

    public String getDid() {
        return did;
    }

    public Integer obtainDid() {
        return MQTTUtils.hex2Int(ByteUtils.convert(this.did));
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void addDid(Integer did) {
        this.did = ByteUtils.convert(MQTTUtils.int2Hex(did));
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }
}
