package com.jhscale.meter.mqtt;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.codec.digest.DigestUtils;

/**
 * @author lie_w
 * @title: MQTTBuilder
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/314:44
 */
public abstract class MQTTBuilder extends JSONModel {

    // 子内容
    private String subContent;

    // 姿容内包
    private String innerContent;

    /**
     * @description: 指令缓存Key
     **/
    public abstract String cacheKey();

    /**
     * @description: 命令字
     **/
    public abstract String command();

    /**
     * @description: 构建组装器
     **/
    public static MQTTPackBuilder packBuilder() {
        return new MQTTPackBuilder();
    }

    /**
     * @description: 构建解析器
     **/
    public static MQTTUnpackBuilder unpackBuilder() {
        return new MQTTUnpackBuilder();
    }

    /**
     * @description: 一机一密生成
     **/
    public static String buildKey(String uid, String user, String password, String random) {
        byte[] randomBytes = ByteUtils.fromHexString(random);
        byte[] baseBytes = "MQTT".getBytes();
        byte[] top = new byte[baseBytes.length];
        for (int i = 0; i < baseBytes.length; i++) {
            top[i] = (byte) (baseBytes[i] + randomBytes[i]);
        }

        byte[] content = ByteUtils.byteMerger(randomBytes, ("JH" + uid + user + password).getBytes());
        content = DigestUtils.sha1(content);

        byte[] bytes = ByteUtils.byteMerger(top, content);
        return ByteUtils.toHexString(bytes);
    }

    protected String getSubContent() {
        return subContent;
    }

    protected void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public String getInnerContent() {
        return innerContent;
    }

    public void setInnerContent(String innerContent) {
        this.innerContent = innerContent;
    }
}
