package com.jhscale.meter.mqtt;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.utils.MQTTUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: MQTTContent
 * @projectName meter-jar
 * @description: MQTT内容缓冲区
 * @date 2021/12/10:35
 */
public class MQTTContentBuffer extends JSONModel {

    // 指令内容
    private StringBuffer content;

    // 剩余内容
    private StringBuffer surplus;

    public MQTTContentBuffer() {
    }

    public MQTTContentBuffer(String buffer) {
        if (StringUtils.isNotBlank(buffer)) {
            int topIndex = buffer.indexOf(MQTTConstant.TOP);
            if (topIndex != -1) {
                buffer = buffer.substring(topIndex);// 有效缓冲区
                if (buffer.length() < 12) {
                    this.surplus = new StringBuffer(buffer);
                } else {
                    Mark mark = new Mark(buffer.substring(2, 4));
                    String lenContent = buffer.substring(8, 8 + mark.getLen());
                    int length = MQTTUtils.hex2Int(lenContent) * 2;
                    int invalidLength = 12 + mark.getLen() + length;
                    if (buffer.length() < invalidLength) {
                        this.surplus = new StringBuffer(buffer);
                    } else {
                        this.content = new StringBuffer(buffer.substring(0, invalidLength));
                        this.surplus = new StringBuffer(invalidLength);
                    }
                }
            }
        }
    }

    /**
     * @description: 有效内容体获取
     **/
    public MQTTContentBuffer validContent(String buffer) {
        if (StringUtils.isNotBlank(buffer)) {
            int topIndex = buffer.indexOf(MQTTConstant.TOP);
            if (topIndex != -1) {
                buffer = buffer.substring(topIndex);// 有效缓冲区
                if (buffer.length() < 12) {
                    this.surplus = new StringBuffer(buffer);
                } else {
                    Mark mark = new Mark(buffer.substring(2, 4));
                    int len = mark.getLen() * 2;
                    String lenContent = buffer.substring(8, 8 + len);
                    int length = MQTTUtils.hex2Int(lenContent) * 2;
                    int invalidLength = 12 + len + length;
                    if (buffer.length() < invalidLength) {
                        this.surplus = new StringBuffer(buffer);
                    } else {
                        this.content = new StringBuffer(buffer.substring(0, invalidLength));
                        this.surplus = new StringBuffer(invalidLength);
                    }
                }
            }
        }
        return this;
    }

    /**
     * @description: 内容缓冲区
     **/
    public StringBuffer contentBuffer() {
        return Objects.isNull(this.content) ? new StringBuffer() : this.content;
    }

    /**
     * @description: 内容数据包
     **/
    public String content() {
        return this.contentBuffer().toString();
    }

    /**
     * @description: 剩余缓冲区
     **/
    public StringBuffer surplusBuffer() {
        return Objects.isNull(this.surplus) ? new StringBuffer() : this.surplus;
    }

    /**
     * @description: 剩余数据包
     **/
    public String surplus() {
        return this.surplusBuffer().toString();
    }

    public StringBuffer getContent() {
        return content;
    }

    public void setContent(StringBuffer content) {
        this.content = content;
    }

    public StringBuffer getSurplus() {
        return surplus;
    }

    public void setSurplus(StringBuffer surplus) {
        this.surplus = surplus;
    }
}
