package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 读取模块信息：端模指令
 * @date 2021/11/410:29
 */
public class X0100_RReadModule extends ICMD {

    // 读取类型
    private Integer type;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.type, 2);
    }

    @Override
    public void fillingSub() {
        super.fillingSub();
        this.type = super.parseInt(2);
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
