package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 读取模块信息：端模指令
 * @date 2021/11/410:29
 */
public class X0100_SReadModule extends ICMD {

    // 请求读取类型
    private Integer type;

    // 主板IMEI号
    private String imei;

    // SIM卡ID
    private String simId;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.type, 2)
                .append(this.imei)
                .append(this.simId);
    }

    @Override
    public void fillingSub() {
        this.type = super.parseInt(2);
        this.imei = super.parseText();
        this.simId = super.parseText();
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getSimId() {
        return simId;
    }

    public void setSimId(String simId) {
        this.simId = simId;
    }
}
