package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 连接MQTT：端模指令
 * @date 2021/11/410:29
 */
public class X0104_RMQTTLink extends ICMD {

    // 状态
    private Character status;

    // 设备唯一标识
    private String uid;

    // 设备名
    private String user;

    // 设备密码
    private String password;

    // 连接分发域名
    private String domain;

    // 心跳间隔
    private Integer keepAlive;

    @Override
    public IMQTT packSubContent() {
        if (this.status != null) {
            return super.packSubContent()
                    .append(status);
        } else {
            return super.packSubContent()
                    .append(this.uid)
                    .append(this.user)
                    .append(this.password)
                    .append(this.domain)
                    .append(this.keepAlive, 4);
        }
    }

    @Override
    public void fillingSub() {
        if (super.over().length() > 2) {
            this.uid = super.parseText();
            this.user = super.parseText();
            this.password = super.parseText();
            this.domain = super.parseText();
            this.keepAlive = super.parseInt(4);
        } else {
            this.status = super.parseChar();
        }
    }

    public Character getStatus() {
        return status;
    }

    public void setStatus(Character status) {
        this.status = status;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getKeepAlive() {
        return keepAlive;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }
}
